/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.campaign;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.service.statistics.campaign.ScheduledIteration;
import org.squashtest.tm.service.statistics.campaign.StatisticUtils;

public class ProgressionStatistics {
    private Collection<String> i18nErrors;
    private Collection<ScheduledIteration> scheduledIterations;
    private List<Object[]> cumulativeExecutionsPerDate;
    private StatisticUtils statisticUtils = new StatisticUtils();

    public void addi18nErrorMessage(String i18nErrorMessage) {
        if (this.i18nErrors == null) {
            this.i18nErrors = new LinkedList<String>();
        }
        this.i18nErrors.add(i18nErrorMessage);
    }

    public Collection<String> getErrors() {
        return this.i18nErrors;
    }

    public Collection<ScheduledIteration> getScheduledIterations() {
        return this.scheduledIterations;
    }

    public void setScheduledIterations(Collection<ScheduledIteration> scheduledIterations) {
        this.scheduledIterations = scheduledIterations;
    }

    public List<Object[]> getCumulativeExecutionsPerDate() {
        return this.cumulativeExecutionsPerDate;
    }

    public void setCumulativeExecutionsPerDate(List<Object[]> cumulativeExecutionsPerDate) {
        this.cumulativeExecutionsPerDate = cumulativeExecutionsPerDate;
    }

    public void computeCumulativeTestPerDate(List<Date> dates) {
        this.setCumulativeExecutionsPerDate(this.statisticUtils.gatherCumulativeTestsPerDate(dates));
    }

    public void computeSchedule() {
        float cumulative = 0.0f;
        for (ScheduledIteration iteration : this.scheduledIterations) {
            iteration.computeCumulativeTestByDate(cumulative);
            cumulative += (float)iteration.getTestplanCount();
        }
    }
}

