/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.domain;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.security.annotation.InheritsAcls;
import org.squashtest.tm.service.security.acls.domain.AnnotatedPropertyObjectIdentityRetrievalStrategy;

public class InheritableAclsObjectIdentityRetrievalStrategy
implements ObjectIdentityRetrievalStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(InheritableAclsObjectIdentityRetrievalStrategy.class);
    private ObjectIdentityRetrievalStrategy delegate = new AnnotatedPropertyObjectIdentityRetrievalStrategy();
    @PersistenceContext
    private EntityManager em;
    private final Map<Key, String> hqlCache = new ConcurrentHashMap<Key, String>();

    public ObjectIdentity getObjectIdentity(Object domainObject) {
        Object identityHolder;
        InheritsAcls inherits = (InheritsAcls)AnnotationUtils.findAnnotation(domainObject.getClass(), InheritsAcls.class);
        if (inherits == null) {
            identityHolder = domainObject;
            LOGGER.trace("Will use domain object for OID retrieval of {}", new Object[]{identityHolder});
        } else {
            identityHolder = this.findAclHolder(domainObject, inherits);
            LOGGER.trace("Will use constrained object {} for OID retrieval of {}", new Object[]{identityHolder, domainObject});
        }
        return this.delegate.getObjectIdentity(identityHolder);
    }

    private Object findAclHolder(Object domainObject, InheritsAcls inherits) {
        LOGGER.trace("Looking for constrained object for OID retrieval of {}", new Object[]{domainObject});
        String hql = this.previouslyBuildQuery(domainObject, inherits);
        if (hql == null) {
            hql = this.buildQuery(domainObject, inherits);
            this.cacheQuery(domainObject, inherits, hql);
        }
        Query query = this.em.createQuery(hql);
        query.setParameter("heir", domainObject);
        return query.getSingleResult();
    }

    private void cacheQuery(Object domainObject, InheritsAcls inherits, String hql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Caching query : [{},{}] -> '{}'", new Object[]{inherits.constrainedClass().getSimpleName(), domainObject.getClass().getSimpleName(), hql});
        }
        this.hqlCache.put(new Key(inherits.constrainedClass(), domainObject.getClass()), hql);
    }

    private String buildQuery(Object domainObject, InheritsAcls inherits) {
        this.checkAnnotation(inherits, domainObject.getClass());
        String entityName = inherits.constrainedClass().getSimpleName();
        String hql = this.isSingleValuedAssociation(inherits) ? "select constrained from " + entityName + " constrained where constrained." + inherits.propertyName() + " = :heir" : "select constrained from " + entityName + " constrained join constrained." + inherits.collectionName() + " as condition where condition = :heir";
        return hql;
    }

    private String previouslyBuildQuery(Object domainObject, InheritsAcls inherits) {
        String hql = this.hqlCache.get(new Key(inherits.constrainedClass(), domainObject.getClass()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cache returned query '" + hql + "' for [" + inherits.constrainedClass().getSimpleName() + "," + domainObject.getClass().getSimpleName() + "]", new Object[0]);
        }
        return hql;
    }

    private boolean isSingleValuedAssociation(InheritsAcls annotation) {
        return StringUtils.isNotBlank((CharSequence)annotation.propertyName());
    }

    private void checkAnnotation(InheritsAcls annotation, Class<?> targetClass) {
        if (annotation.constrainedClass() == null) {
            throw new IllegalStateException("Property constrainedClass of annotation InheritsAcls should not be null. Target class: " + String.valueOf(targetClass));
        }
        boolean singleValuedCandidate = StringUtils.isNotBlank((CharSequence)annotation.propertyName());
        boolean multiValuedCandidate = StringUtils.isNotBlank((CharSequence)annotation.collectionName());
        if (singleValuedCandidate && multiValuedCandidate) {
            throw new IllegalStateException("Only one of 'propertyName' and 'collectionName' property of annotation InheritsAcls should be set. Target class: " + String.valueOf(targetClass));
        }
        if (!singleValuedCandidate && !multiValuedCandidate) {
            throw new IllegalStateException("At least one of 'propertyName' and 'collectionName' properties of annotation InheritsAcls should be set. Target class: " + String.valueOf(targetClass));
        }
    }

    private static final class Key {
        public final Class<?> constrained;
        public final Class<?> heir;

        private Key(Class<?> constrained, Class<?> heir) {
            this.constrained = constrained;
            this.heir = heir;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.heir == null ? 0 : this.heir.hashCode());
            result = 31 * result + (this.constrained == null ? 0 : this.constrained.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.heir == null ? other.heir != null : !this.heir.equals(other.heir)) {
                return false;
            }
            return !(this.constrained == null ? other.constrained != null : !this.constrained.equals(other.constrained));
        }
    }
}

