/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.domain;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.Serializable;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityGenerator;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.squashtest.tm.service.security.acls.domain.objectidentity.OptimizedObjectIdentityRetrievalStrategy;

public class DatabaseBackedObjectIdentityGeneratorStrategy
implements ObjectIdentityGenerator {
    @PersistenceContext
    private EntityManager em;
    private final ObjectIdentityRetrievalStrategy objectRetrievalStrategy;
    private final OptimizedObjectIdentityRetrievalStrategy optimizedObjectIdentityRetrievalStrategy;

    public DatabaseBackedObjectIdentityGeneratorStrategy(ObjectIdentityRetrievalStrategy objectRetrievalStrategy, OptimizedObjectIdentityRetrievalStrategy optimizedObjectIdentityRetrievalStrategy) {
        this.objectRetrievalStrategy = objectRetrievalStrategy;
        this.optimizedObjectIdentityRetrievalStrategy = optimizedObjectIdentityRetrievalStrategy;
    }

    public ObjectIdentity createObjectIdentity(Serializable id, String type) {
        if (this.optimizedObjectIdentityRetrievalStrategy.isHandled(type)) {
            return this.optimizedObjectIdentityRetrievalStrategy.createObjectIdentity(id, type);
        }
        return this.createObjectIdentityFromHibernateEntity(id, type);
    }

    private ObjectIdentity createObjectIdentityFromHibernateEntity(Serializable id, String type) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
            Object instance = this.em.find(clazz, (Object)id);
            if (instance == null) {
                return new UnknownObjectIdentity(type);
            }
            return this.objectRetrievalStrategy.getObjectIdentity(instance);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class UnknownObjectIdentity
    implements ObjectIdentity {
        private final String type;

        public UnknownObjectIdentity(String type) {
            this.type = type + ":Unknown";
        }

        public Serializable getIdentifier() {
            return Integer.valueOf(0);
        }

        public String getType() {
            return this.type;
        }
    }
}

