/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.requirement;

import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;

public class VerifiedRequirement {
    private final boolean directVerification;
    private final Set<ActionTestStep> verifyingSteps = new HashSet<ActionTestStep>(0);
    private final RequirementVersion verifiedRequirementVersion;

    public VerifiedRequirement(@NotNull RequirementVersionCoverage requirementVersionCoverage, boolean directVerification) {
        this.verifiedRequirementVersion = requirementVersionCoverage.getVerifiedRequirementVersion();
        this.directVerification = directVerification;
    }

    public VerifiedRequirement(@NotNull RequirementVersion version, boolean directlyVerified) {
        this.verifiedRequirementVersion = version;
        this.directVerification = directlyVerified;
    }

    public RequirementVersion getVerifiedRequirementVersion() {
        return this.verifiedRequirementVersion;
    }

    public Project getProject() {
        return this.getVerifiedRequirementVersion().getRequirement().getProject();
    }

    public RequirementStatus getStatus() {
        return this.getVerifiedRequirementVersion().getStatus();
    }

    public String getName() {
        return this.getVerifiedRequirementVersion().getName();
    }

    public int getVersionNumber() {
        return this.getVerifiedRequirementVersion().getVersionNumber();
    }

    public String getDescription() {
        return this.getVerifiedRequirementVersion().getDescription();
    }

    public String getReference() {
        return this.getVerifiedRequirementVersion().getReference();
    }

    public RequirementCriticality getCriticality() {
        return this.getVerifiedRequirementVersion().getCriticality();
    }

    public InfoListItem getCategory() {
        return this.getVerifiedRequirementVersion().getCategory();
    }

    public boolean isDirectVerification() {
        return this.directVerification;
    }

    public Set<Milestone> getMilestones() {
        return this.getVerifiedRequirementVersion().getMilestones();
    }

    public Long getId() {
        return this.getVerifiedRequirementVersion().getId();
    }

    public Set<ActionTestStep> getVerifyingSteps() {
        return this.verifyingSteps;
    }

    public boolean hasStepAsVerifying(long stepId) {
        for (ActionTestStep step : this.verifyingSteps) {
            if (!step.getId().equals(stepId)) continue;
            return true;
        }
        return false;
    }

    public VerifiedRequirement withVerifyingStepsFrom(TestCase testCase) {
        RequirementVersionCoverage coverage = this.verifiedRequirementVersion.getRequirementVersionCoverageOrNullFor(testCase);
        if (coverage != null) {
            this.verifyingSteps.addAll(coverage.getVerifyingSteps());
        }
        return this;
    }
}

