/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.execution.SessionNoteKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.SessionNoteDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository
public class SessionNoteDaoImpl
extends HibernateEntityDao<SessionNote>
implements SessionNoteDao {
    private final DSLContext dslContext;

    public SessionNoteDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public Long createSessionNote(long executionId, SessionNoteKind noteKind, String noteContent, Integer noteOrder) {
        ExploratoryExecution execution = (ExploratoryExecution)this.entityManager.find(ExploratoryExecution.class, (Object)executionId);
        SessionNote sessionNote = new SessionNote();
        sessionNote.setKind(noteKind);
        sessionNote.setContent(noteContent);
        sessionNote.setExecution(execution);
        execution.addSessionNote(sessionNote, noteOrder);
        this.flush();
        return sessionNote.getId();
    }

    @Override
    public void updateSessionNoteKind(long noteId, SessionNoteKind kind) {
        SessionNote sessionNote = (SessionNote)this.findById(noteId);
        sessionNote.setKind(kind);
    }

    @Override
    public void updateSessionNoteContent(long noteId, String content) {
        SessionNote sessionNote = (SessionNote)this.findById(noteId);
        sessionNote.setContent(content);
    }

    @Override
    public void deleteSessionNote(long noteId) {
        SessionNote sessionNote = (SessionNote)this.findById(noteId);
        sessionNote.getExecution().removeSessionNote(sessionNote);
        this.entityManager.remove((Object)sessionNote);
    }

    @Override
    public Long findExploratoryExecutionId(long noteId) {
        return (Long)this.dslContext.select((SelectField)Tables.SESSION_NOTE.EXECUTION_ID).from((TableLike)Tables.SESSION_NOTE).where(Tables.SESSION_NOTE.NOTE_ID.eq((Object)noteId)).fetchOneInto(Long.class);
    }
}

