/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.hibernate.Hibernate;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateExecutionStepDao
extends HibernateEntityDao<ExecutionStep>
implements ExecutionStepDao {
    private final DSLContext dslContext;

    public HibernateExecutionStepDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public Execution findParentExecution(Long executionStepId) {
        ChildIdQueryParameterCallback newCallBack = new ChildIdQueryParameterCallback(executionStepId);
        Execution exec = (Execution)this.executeEntityNamedQuery("executionStep.findParentNode", newCallBack);
        Hibernate.initialize((Object)exec.getSteps());
        return exec;
    }

    @Override
    public MultiMap findStepExecutionsStatus(List<Long> testCaseIds, List<Long> testStepIds) {
        if (testStepIds.isEmpty()) {
            return new MultiValueMap();
        }
        ArrayList execSteps = new ArrayList();
        for (Long tcId : testCaseIds) {
            TypedQuery q = this.entityManager.createNamedQuery("execution.findAllByTestCaseIdAndItIdOrderByRunDate", Execution.class);
            q.setParameter("testCaseId", (Object)tcId);
            List execs = q.getResultList();
            if (execs.isEmpty()) continue;
            execSteps.addAll(((Execution)execs.get(0)).getSteps());
        }
        MultiValueMap result = new MultiValueMap();
        for (ExecutionStep executionStep : execSteps) {
            Optional.of(executionStep).map(ExecutionStep::getReferencedTestStep).map(TestStep::getId).ifPresent(arg_0 -> HibernateExecutionStepDao.lambda$2((MultiMap)result, executionStep, arg_0));
        }
        return result;
    }

    @Override
    public List<Long> findAllIdsByExecutionIds(Collection<Long> executionIds) {
        if (executionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        TypedQuery fetchQuery = this.entityManager.createNamedQuery("ExecutionStep.findAllIdsByExecutionIds", Long.class);
        fetchQuery.setParameter("executionIds", executionIds);
        return fetchQuery.getResultList();
    }

    @Override
    public Map<Long, Long> getTestStepIdsWithAttachmentListIds(Collection<Long> executionIds, boolean complete) {
        List<Long> executionStepIds = this.findAllIdsByExecutionIds(executionIds);
        Condition baseCondition = Tables.EXECUTION_STEP.EXECUTION_STEP_ID.in(executionStepIds);
        Condition condition = complete ? baseCondition : baseCondition.and(Tables.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)ExecutionStatus.SUCCESS.name()));
        return this.dslContext.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID).from((TableLike)Tables.EXECUTION_STEP).where(condition).fetchMap((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (Field)Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID);
    }

    @Override
    public void deleteAllByIds(List<Long> executionStepIds) {
        if (executionStepIds.isEmpty()) {
            return;
        }
        Query fetchQuery = this.entityManager.createNamedQuery("ExecutionStep.deleteAllByIds");
        fetchQuery.setParameter("executionStepIds", executionStepIds);
        fetchQuery.executeUpdate();
    }

    private static /* synthetic */ void lambda$2(MultiMap multiMap, ExecutionStep executionStep, Long g) {
        Object object = multiMap.put((Object)executionStep.getReferencedTestStep().getId(), (Object)executionStep);
    }

    private static final class ChildIdQueryParameterCallback
    implements SetQueryParametersCallback {
        private Long childId;

        private ChildIdQueryParameterCallback(Long childId) {
            this.childId = childId;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter("childId", (Object)this.childId);
        }
    }
}

