/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Row2;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.foundation.collection.JpaPagingUtils;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

public class CustomFieldBindingDaoImpl
extends HibernateEntityDao<CustomFieldBinding>
implements CustomCustomFieldBindingDao {
    @Inject
    private DSLContext dslContext;

    @Override
    public List<CustomFieldBinding> findAllForProjectAndEntity(long projectId, BindableEntity boundEntity, Paging paging) {
        TypedQuery q = this.entityManager.createNamedQuery("CustomFieldBinding.findAllForProjectAndEntity", CustomFieldBinding.class);
        q.setParameter("projectId", (Object)projectId);
        q.setParameter("entityType", (Object)boundEntity);
        JpaPagingUtils.addPaging((Query)q, paging);
        return q.getResultList();
    }

    @Override
    public boolean cufBindingAlreadyExists(long projectId, BindableEntity entity, long cufId) {
        Query q = this.entityManager.createNamedQuery("CustomFieldBinding.cufBindingAlreadyExists");
        q.setParameter("cufId", (Object)cufId);
        q.setParameter("boundEntity", (Object)entity);
        q.setParameter("projectId", (Object)projectId);
        Long numberOfLines = (Long)q.getSingleResult();
        return numberOfLines > 0L;
    }

    @Override
    public void removeCustomFieldBindings(List<Long> bindingIds) {
        if (!bindingIds.isEmpty()) {
            List<Row2<String, Long>> bindingTypes = this.findAllCustomFieldBindingTypeFromCfbIds(bindingIds).stream().map(CustomFieldBindingType::toRow).toList();
            this.entityManager.createNamedQuery("CustomFieldBinding.removeCustomFieldBindings").setParameter("cfbIds", bindingIds).executeUpdate();
            this.reorderBindingPositions(bindingTypes);
        }
    }

    protected List<CustomFieldBindingType> findAllCustomFieldBindingTypeFromCfbIds(List<Long> cfbId) {
        return this.dslContext.select((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID).from((TableLike)Tables.CUSTOM_FIELD_BINDING).where(Tables.CUSTOM_FIELD_BINDING.CFB_ID.in(cfbId)).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID}).fetchInto(CustomFieldBindingType.class);
    }

    protected void reorderBindingPositions(List<Row2<String, Long>> customFieldBindingTypes) {
        Field bindingIdField = Tables.CUSTOM_FIELD_BINDING.CFB_ID.as("reorder_cfb_id");
        Field positionField = Tables.CUSTOM_FIELD_BINDING.POSITION.as("reorder_position");
        Table bindingPositionReorder = DSL.select((SelectField)bindingIdField, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID}).orderBy(new OrderField[]{Tables.CUSTOM_FIELD_BINDING.POSITION}).as(positionField)).from((TableLike)Tables.CUSTOM_FIELD_BINDING).where(DSL.row((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID).in(customFieldBindingTypes)).asTable();
        this.reorderBindingBySQLDialect((Table<Record2<Long, Integer>>)bindingPositionReorder, (Field<Long>)bindingIdField, (Field<Integer>)positionField);
    }

    private void reorderBindingBySQLDialect(Table<Record2<Long, Integer>> bindingPositionReorder, Field<Long> bindingIdField, Field<Integer> positionField) {
        if (SQLDialect.POSTGRES.equals((Object)this.dslContext.dialect())) {
            this.dslContext.update((Table)Tables.CUSTOM_FIELD_BINDING).set((Field)Tables.CUSTOM_FIELD_BINDING.POSITION, positionField).from(bindingPositionReorder).where(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq(bindingIdField)).and(Tables.CUSTOM_FIELD_BINDING.POSITION.ne(positionField)).execute();
        } else {
            this.dslContext.update((Table)Tables.CUSTOM_FIELD_BINDING.join(bindingPositionReorder).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq(bindingIdField))).set((Field)Tables.CUSTOM_FIELD_BINDING.POSITION, positionField).where(Tables.CUSTOM_FIELD_BINDING.POSITION.ne(positionField)).execute();
        }
    }

    protected record CustomFieldBindingType(BindableEntity boundEntity, Long projectId) {
        Row2<String, Long> toRow() {
            return DSL.row((Object)this.boundEntity.name(), (Object)this.projectId);
        }
    }
}

