/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class CampaignFolderCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public CampaignFolderCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> campaignFolder = this.collectCampaignFolders(ids);
        this.appendMilestonesByProject(campaignFolder);
        return campaignFolder;
    }

    private Map<Long, DataRow> collectCampaignFolders(List<Long> ids) {
        List foldersWithSprintGroupParent = this.dsl.select((SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.CAMPAIGN_FOLDER).leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).where(Tables.CAMPAIGN_FOLDER.CLN_ID.in(ids)).and(Tables.SPRINT_GROUP.CLN_ID.isNotNull()).fetchInto(Long.class);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)DSL.count((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID).as("CHILD_COUNT")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(ids)).groupBy(new GroupField[]{Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.NAME, Tables.CLN_RELATIONSHIP.ANCESTOR_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.CAMPAIGN_FOLDER, (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            boolean hasSprintGroupParent = foldersWithSprintGroupParent.contains(tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
            dataRow.addData("HAS_SPRINT_GROUP_PARENT", hasSprintGroupParent);
            return dataRow;
        }));
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.CAMPAIGN_FOLDER;
    }
}

