/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.inject.Inject;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record6;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectUnionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedCustomFieldValueType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.DenormalizedCustomFieldValueDto;
import org.squashtest.tm.service.internal.repository.display.DenormalizedCustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Repository
public class DenormalizedCustomFieldValueDisplayDaoImpl
implements DenormalizedCustomFieldValueDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public ListMultimap<Long, DenormalizedCustomFieldValueDto> findDenormalizedCustomFieldValues(DenormalizedFieldHolderType fieldHolderType, List<Long> entityIds) {
        if (Objects.nonNull(fieldHolderType) && Objects.nonNull(entityIds) && !entityIds.isEmpty()) {
            return this.fetchDenormalizedCustomFieldValues(fieldHolderType, entityIds);
        }
        return ArrayListMultimap.create();
    }

    @Override
    public List<DenormalizedCustomFieldValueDto> findDenormalizedCustomFieldValues(DenormalizedFieldHolderType fieldHolderType, Long entityId) {
        ListMultimap<Long, DenormalizedCustomFieldValueDto> denormalizedCustomFieldValues = this.findDenormalizedCustomFieldValues(fieldHolderType, Collections.singletonList(entityId));
        return denormalizedCustomFieldValues.get((Object)entityId);
    }

    private ListMultimap<Long, DenormalizedCustomFieldValueDto> fetchDenormalizedCustomFieldValues(DenormalizedFieldHolderType fieldHolderType, List<Long> entityIds) {
        ArrayListMultimap values = ArrayListMultimap.create();
        SelectUnionStep<Record6<Long, String, String, String, Long, String>> selectRequest = this.craftSelectRequest(fieldHolderType, entityIds);
        selectRequest.fetch().into(DenormalizedCustomFieldValueDto.class).forEach(arg_0 -> DenormalizedCustomFieldValueDisplayDaoImpl.lambda$0((ListMultimap)values, arg_0));
        return values;
    }

    private SelectUnionStep<Record6<Long, String, String, String, Long, String>> craftSelectRequest(DenormalizedFieldHolderType fieldHolderType, List<Long> entityIds) {
        EnumSet<DenormalizedCustomFieldValueType> customFieldValueTypes = EnumSet.allOf(DenormalizedCustomFieldValueType.class);
        Deque clauses = customFieldValueTypes.stream().map(type -> this.getSelectClause(fieldHolderType, (DenormalizedCustomFieldValueType)type, entityIds)).collect(Collectors.toCollection(ArrayDeque::new));
        SelectUnionStep selectRequest = (SelectUnionStep)clauses.pop();
        while (clauses.peek() != null) {
            selectRequest.unionAll((Select)clauses.pop());
        }
        return selectRequest;
    }

    private SelectUnionStep<Record6<Long, String, String, String, Long, String>> getSelectClause(DenormalizedFieldHolderType fieldHolderType, DenormalizedCustomFieldValueType type, List<Long> entityIds) {
        if (type.isMultiValue()) {
            return this.getMultiValueClause(fieldHolderType, type, entityIds);
        }
        return this.getSingleValueClause(fieldHolderType, type, entityIds);
    }

    private SelectUnionStep<Record6<Long, String, String, String, Long, String>> getMultiValueClause(DenormalizedFieldHolderType fieldHolderType, DenormalizedCustomFieldValueType type, List<Long> entityIds) {
        Table customFieldValueOption = this.dsl.select((SelectField)Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE_OPTION.LABEL, (SelectField)Tables.DENORMALIZED_FIELD_VALUE_OPTION.POSITION).from((TableLike)Tables.DENORMALIZED_FIELD_VALUE_OPTION).orderBy((OrderField)Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID, (OrderField)Tables.DENORMALIZED_FIELD_VALUE_OPTION.POSITION).asTable("DENORMALIZED_FIELD_VALUE_OPTION");
        return this.dsl.select((SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.LABEL, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE, (SelectField)DSL.listAgg((Field)type.getValueColumn(), (String)"|").withinGroupOrderBy(new OrderField[]{Tables.DENORMALIZED_FIELD_VALUE_OPTION.POSITION}).as("VALUE"), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID.as("ID"), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE).from((TableLike)Tables.DENORMALIZED_FIELD_VALUE).leftJoin((TableLike)customFieldValueOption).on(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID.eq((Field)Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID)).where(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)fieldHolderType.name())).and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.in(entityIds)).and(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)type.getDiscriminatorValue())).groupBy(new GroupField[]{Tables.DENORMALIZED_FIELD_VALUE.DFV_ID});
    }

    private SelectUnionStep<Record6<Long, String, String, String, Long, String>> getSingleValueClause(DenormalizedFieldHolderType fieldHolderType, DenormalizedCustomFieldValueType type, List<Long> entityIds) {
        return this.dsl.select((SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.LABEL, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE, (SelectField)type.getValueColumn().as("VALUE"), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID.as("ID"), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE).from((TableLike)Tables.DENORMALIZED_FIELD_VALUE).where(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)fieldHolderType.name())).and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.in(entityIds)).and(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)type.getDiscriminatorValue()));
    }

    private static /* synthetic */ void lambda$0(ListMultimap listMultimap, DenormalizedCustomFieldValueDto denormalizedCustomFieldValueDto) {
        if (denormalizedCustomFieldValueDto.getFieldType().equals(CustomFieldValueType.RTF.name())) {
            String sanitized = HTMLCleanupUtils.cleanHtml(denormalizedCustomFieldValueDto.getValue());
            denormalizedCustomFieldValueDto.setValue(sanitized);
        }
        listMultimap.put((Object)denormalizedCustomFieldValueDto.getDenormalizedFieldHolderId(), (Object)denormalizedCustomFieldValueDto);
    }
}

