/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.display.DatasetDuplicationTreeBrowserDao;
import org.squashtest.tm.service.internal.repository.display.MultipleHierarchyTreeBrowserDao;
import org.squashtest.tm.service.internal.testcase.ParameterComparator;

@Repository
public class DatasetDuplicationTreeBrowserDaoImpl
implements DatasetDuplicationTreeBrowserDao {
    private final ParameterDao parameterDao;
    private final DSLContext dsl;
    private final MultipleHierarchyTreeBrowserDao multipleHierarchyTreeBrowserDao;

    public DatasetDuplicationTreeBrowserDaoImpl(ParameterDao parameterDao, DSLContext dsl, MultipleHierarchyTreeBrowserDao multipleHierarchyTreeBrowserDao) {
        this.parameterDao = parameterDao;
        this.dsl = dsl;
        this.multipleHierarchyTreeBrowserDao = multipleHierarchyTreeBrowserDao;
    }

    @Override
    public Set<NodeReference> findLibraryReferences(NodeWorkspace workspace, Collection<Long> projectIds) {
        return this.multipleHierarchyTreeBrowserDao.findLibraryReferences(workspace, projectIds);
    }

    @Override
    public ListMultimap<NodeReference, NodeReference> findChildrenReference(Set<NodeReference> parentReferences) {
        return this.multipleHierarchyTreeBrowserDao.findChildrenReference(parentReferences);
    }

    @Override
    public Set<NodeReference> findAncestors(NodeReferences nodeReferences) {
        return this.multipleHierarchyTreeBrowserDao.findAncestors(nodeReferences);
    }

    @Override
    public Set<NodeReference> getEligibleTestCaseNodeReferences(Set<NodeReference> nodesToFilter, List<String> sourceDataSetParameters) {
        Set<Long> testCaseIds = nodesToFilter.stream().filter(node -> NodeType.TEST_CASE.equals((Object)node.getNodeType())).map(NodeReference::getId).collect(Collectors.toSet());
        List<Long> tclnIds = this.filterEligibleTclnIds(testCaseIds, sourceDataSetParameters);
        return nodesToFilter.stream().filter(nodeReference -> !NodeType.TEST_CASE.equals((Object)nodeReference.getNodeType()) || tclnIds.contains(nodeReference.getId())).collect(Collectors.toSet());
    }

    public List<Long> filterEligibleTclnIds(Collection<Long> testCaseIds, List<String> sourceParameters) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        List validTestCaseIds = this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name()))).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds).and(Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNull()).and(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNull()).and(Tables.MILESTONE.MILESTONE_ID.isNull())).fetchInto(Long.class);
        if (validTestCaseIds.isEmpty()) {
            return validTestCaseIds;
        }
        Map parameterNamesByTestCaseId = this.parameterDao.findOwnParametersNamesByTestCaseIds(testCaseIds);
        return validTestCaseIds.stream().filter(id -> ParameterComparator.checkHasMatchingParameters(sourceParameters, parameterNamesByTestCaseId.getOrDefault(id, Collections.emptyList()))).toList();
    }
}

