/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.google.common.collect.Lists;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateOperation;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimpleOperation;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueOption;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.jpql.ExtOps;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.QueryStrategy;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.service.internal.query.EnumHelper;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.QueryBuilder;
import org.squashtest.tm.service.internal.query.SubQueryBuilder;

class QuerydslToolbox {
    public static final int BY_YEAR_SUBSTRING_SIZE = 4;
    public static final int BY_MONTH_SUBSTRING_SIZE = 7;
    public static final int BY_DAY_SUBSTRING_SIZE = 10;
    private static final String NOT_YET_SUPPORTED = "' not yet supported";
    private static final int QUERY_DSL_RECURSION_BATCH = 5000;
    private String subContext;
    private EnumMap<InternalEntityType, String> nondefaultPath = new EnumMap(InternalEntityType.class);

    QuerydslToolbox() {
    }

    QuerydslToolbox(String subContext) {
        this.subContext = subContext;
    }

    QuerydslToolbox(QueryColumnPrototypeInstance column) {
        this.subContext = "subcolumn_" + String.valueOf(column.getColumn().getId());
    }

    void setSubContext(String subContext) {
        this.subContext = subContext;
    }

    String getSubContext() {
        return this.subContext;
    }

    void forceAlias(InternalEntityType type, String alias) {
        this.nondefaultPath.put(type, alias);
    }

    String getQName(InternalEntityType type) {
        EntityPathBase<?> path = type.getQBean();
        Object name = this.nondefaultPath.containsKey((Object)type) ? this.nondefaultPath.get((Object)type) : (this.subContext == null ? path.getMetadata().getName() : path.getMetadata().getName() + "_" + this.subContext);
        return name;
    }

    EntityPathBase<?> getQBean(InternalEntityType type) {
        String name = this.getQName(type);
        return type.getAliasedQBean(name);
    }

    EntityPathBase<?> getQBean(SpecializedEntityType domainType) {
        InternalEntityType type = InternalEntityType.fromSpecializedType(domainType);
        return this.getQBean(type);
    }

    EntityPathBase<?> getQBean(QueryColumnPrototypeInstance column) {
        InternalEntityType type = InternalEntityType.fromSpecializedType(column.getSpecializedType());
        return this.getQBean(type);
    }

    String getAlias(EntityPathBase<?> path) {
        return path.getMetadata().getName();
    }

    String getCustomFieldValueTableAlias(QueryColumnPrototype columnPrototype, Long cufId) {
        if (columnPrototype.getDataType().equals((Object)DataType.TAG)) {
            return this.getCustomFieldValueOptionTableAlias(columnPrototype, cufId);
        }
        return this.getCustomFieldValueStandardTableAlias(columnPrototype, cufId);
    }

    String getCustomFieldValueStandardTableAlias(QueryColumnPrototype columnPrototype, Long cufId) {
        return columnPrototype.getLabel() + "_" + Math.abs(cufId);
    }

    String getCustomFieldValueOptionTableAlias(QueryColumnPrototype columnPrototype, Long cufId) {
        return columnPrototype.getLabel() + "_value_option_" + Math.abs(cufId);
    }

    Set<String> getJoinedAliases(ExtendedHibernateQuery<?> query) {
        AliasCollector collector = new AliasCollector();
        for (JoinExpression join : query.getMetadata().getJoins()) {
            join.getTarget().accept((Visitor)collector, collector.getAliases());
        }
        return collector.getAliases();
    }

    boolean isAggregate(Operation operation) {
        return switch (operation) {
            case Operation.SUM, Operation.COUNT -> true;
            default -> false;
        };
    }

    boolean isWhereClauseComponent(QueryFilterColumn filter) {
        QueryFilterColumn column = filter;
        while (column.getColumn().getColumnType() == ColumnType.CALCULATED && this.subQueryStrategy((QueryColumnPrototypeInstance)column) == QueryStrategy.INLINED) {
            column = (QueryColumnPrototypeInstance)column.getColumn().getSubQuery().getProjectionColumns().get(0);
        }
        return !this.isAggregate(column.getOperation());
    }

    boolean isHavingClauseComponent(QueryFilterColumn filter) {
        return !this.isWhereClauseComponent(filter);
    }

    boolean isSubquery(QueryColumnPrototypeInstance proto) {
        return proto.getColumn().getColumnType() == ColumnType.CALCULATED;
    }

    Expression<?> createAsSelect(QueryColumnPrototypeInstance col) {
        QueryColumnPrototype proto = col.getColumn();
        Expression<?> selectElement = switch (proto.getColumnType()) {
            case ColumnType.ENTITY, ColumnType.ATTRIBUTE -> this.createAttributeSelect(col);
            case ColumnType.CALCULATED -> this.createSubquerySelect(col);
            case ColumnType.CUF -> this.createCustomFieldSelect(col);
            default -> throw new MatchException(null, null);
        };
        return selectElement;
    }

    BooleanExpression createAsPredicate(QueryFilterColumn filter) {
        QueryColumnPrototype proto = filter.getColumn();
        BooleanExpression predicate = switch (proto.getColumnType()) {
            case ColumnType.ENTITY, ColumnType.ATTRIBUTE -> this.createAttributePredicate(filter);
            case ColumnType.CALCULATED -> this.createSubqueryPredicate(filter);
            case ColumnType.CUF -> this.createCufPredicate(filter);
            default -> throw new MatchException(null, null);
        };
        return predicate;
    }

    Expression<?> createAsGroupBy(QueryColumnPrototypeInstance col) {
        return this.createAsSelect(col);
    }

    Expression<?> createAsSortBy(QueryColumnPrototypeInstance col) {
        if (col.getDataType().isAssignableToLevelEnum()) {
            return this.createAsCaseWhen(col);
        }
        return this.createAsSelect(col);
    }

    PathBuilder makePath(InternalEntityType src, InternalEntityType dest, String attribute) {
        Class<?> srcClass = src.getEntityClass();
        Class<?> destClass = dest.getEntityClass();
        String srcAlias = this.getQName(src);
        return new PathBuilder(srcClass, srcAlias).get(attribute, destClass);
    }

    PathBuilder makePath(EntityPathBase<?> src, EntityPathBase<?> dest, String attribute) {
        Class srcClass = src.getType();
        Class destClass = dest.getType();
        String srcAlias = src.getMetadata().getName();
        return new PathBuilder(srcClass, srcAlias).get(attribute, destClass);
    }

    Expression<?> createAttributeSelect(QueryColumnPrototypeInstance column) {
        PathBuilder<?> attribute = this.attributePath(column);
        Operation operation = column.getOperation();
        if (operation != Operation.NONE) {
            attribute = this.applyOperation(operation, (Expression<?>)attribute, (Expression<?>[])new Expression[0]);
        }
        return attribute;
    }

    Expression<?> createSubquerySelect(QueryColumnPrototypeInstance col) {
        ExtendedHibernateQuery<?> expression = null;
        switch (this.subQueryStrategy(col)) {
            case SUBQUERY: {
                SubQueryBuilder qbuilder = this.createSubSelectBuilder(col);
                expression = qbuilder.createQuery();
                break;
            }
            case INLINED: {
                QuerydslToolbox subtoolbox = new QuerydslToolbox(col);
                QueryModel subqueryModel = col.getColumn().getSubQuery();
                QueryProjectionColumn projectedColumn = (QueryProjectionColumn)subqueryModel.getProjectionColumns().get(0);
                expression = subtoolbox.createAsSelect((QueryColumnPrototypeInstance)projectedColumn);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempted to create a subquery for column '" + col.getColumn().getLabel() + "' from what appears to be a main query. This is probably due to an ill-inserted entry in the database, please report this to the suppport.");
            }
        }
        Operation operation = col.getOperation();
        if (operation != Operation.NONE) {
            expression = this.applyOperation(operation, (Expression<?>)expression, (Expression<?>[])new Expression[0]);
        }
        return expression;
    }

    private SubQueryBuilder createSubSelectBuilder(QueryColumnPrototypeInstance col) {
        SpecializedEntityType specType = col.getSpecializedType();
        InternalEntityType internalType = InternalEntityType.fromSpecializedType(specType);
        EntityPathBase<?> colBean = this.getQBean(col);
        return new SubQueryBuilder(col).asSubselectQuery().withRootEntity(internalType).joinRootEntityOn((Expression<?>)colBean);
    }

    private Expression<?> createCustomFieldSelect(QueryColumnPrototypeInstance col) {
        QueryColumnPrototype columnPrototype = col.getColumn();
        DataType dataType = columnPrototype.getDataType();
        Long cufId = col.getCufId();
        String alias = this.getCustomFieldValueTableAlias(columnPrototype, cufId);
        Operation operation = col.getOperation();
        Expression<?> expression = this.makePathForCFV(dataType, alias);
        if (operation != Operation.NONE) {
            expression = dataType == DataType.DATE_AS_STRING ? this.applyOperationForDateCustomFields(operation, expression) : this.applyOperation(operation, expression, new Expression[0]);
        }
        return expression;
    }

    BooleanExpression createAttributePredicate(QueryFilterColumn filter) {
        Operation operation = filter.getOperation();
        QueryColumnPrototype column = filter.getColumn();
        DataType datatype = column.getDataType();
        PathBuilder<?> attrExpr = this.attributePath((QueryColumnPrototypeInstance)filter);
        List<Expression<?>> valExpr = this.makeOperands(column, operation, filter.getValues());
        Expression[] operands = valExpr.toArray(new Expression[valExpr.size()]);
        return this.doCreatePredicate(operation, (Expression<?>)attrExpr, datatype, filter, (Expression<?>[])operands);
    }

    BooleanExpression createSubqueryPredicate(QueryFilterColumn filter) {
        return switch (this.subQueryStrategy((QueryColumnPrototypeInstance)filter)) {
            case QueryStrategy.SUBQUERY -> this.getSubQueryPredicate(filter);
            case QueryStrategy.INLINED -> this.getInlinedPredicate(filter);
            default -> throw new IllegalArgumentException("Attempted to create a subquery for column '" + filter.getColumn().getLabel() + "' from what appears to be a main query. This is probably due to an ill-inserted entry in the database, please report this to the support.");
        };
    }

    private BooleanExpression getSubQueryPredicate(QueryFilterColumn filter) {
        EntityPathBase<?> colBean = this.getQBean((QueryColumnPrototypeInstance)filter);
        SubQueryBuilder qbuilder = new SubQueryBuilder((QueryColumnPrototypeInstance)filter).asSubwhereQuery().withRootEntity(filter.getSpecializedType()).joinRootEntityOn((Expression<?>)colBean).filterOn(filter);
        ExtendedHibernateQuery<?> subquery = ((QueryBuilder)qbuilder).createQuery();
        BooleanOperation predicate = Expressions.predicate((Operator)Ops.EXISTS, (Expression[])new Expression[]{subquery});
        return predicate;
    }

    private BooleanExpression getInlinedPredicate(QueryFilterColumn filter) {
        QueryModel subqueryModel = filter.getColumn().getSubQuery();
        QueryProjectionColumn subProjection = (QueryProjectionColumn)subqueryModel.getProjectionColumns().get(0);
        QuerydslToolbox subtoolbox = new QuerydslToolbox((QueryColumnPrototypeInstance)filter);
        Expression<?> subexpr = subtoolbox.createAsSelect((QueryColumnPrototypeInstance)subProjection);
        List<Expression<?>> valExpr = this.makeOperands(filter.getColumn(), filter.getOperation(), filter.getValues());
        Expression[] operands = valExpr.toArray(new Expression[valExpr.size()]);
        BooleanExpression predicate = this.createPredicate(filter.getOperation(), subexpr, subProjection.getDataType(), operands);
        return predicate;
    }

    BooleanExpression createCufPredicate(QueryFilterColumn filter) {
        QueryColumnPrototype columnPrototype = filter.getColumn();
        DataType dataType = columnPrototype.getDataType();
        Long cufId = filter.getCufId();
        String alias = this.getCustomFieldValueStandardTableAlias(columnPrototype, cufId);
        Operation operation = filter.getOperation();
        List<Expression<?>> valExpr = this.makeOperands(columnPrototype, operation, filter.getValues());
        Expression[] operands = valExpr.toArray(new Expression[valExpr.size()]);
        PathBuilder<?> attrExpr = switch (dataType) {
            case DataType.STRING, DataType.DATE_AS_STRING, DataType.BOOLEAN_AS_STRING, DataType.LIST -> this.makePathForValueCFV(alias);
            case DataType.NUMERIC -> this.makePathForNumericValueCFV(alias);
            case DataType.TAG -> {
                alias = this.getCustomFieldValueOptionTableAlias(columnPrototype, cufId);
                yield this.makePathForTagValueCFV(alias);
            }
            default -> throw new IllegalArgumentException("The datatype " + dataType.name() + " is not handled by custom report engine");
        };
        return this.createPredicate(operation, (Expression<?>)attrExpr, dataType, (Expression<?>[])operands);
    }

    Expression<?> makePathForCFV(DataType dataType, String alias) {
        return switch (dataType) {
            case DataType.STRING, DataType.DATE_AS_STRING, DataType.BOOLEAN_AS_STRING, DataType.LIST -> this.makePathForValueCFV(alias);
            case DataType.NUMERIC -> this.makePathForNumericValueCFV(alias);
            case DataType.TAG -> this.makePathForTagValueCFV(alias);
            default -> throw new IllegalArgumentException("Unknown datatype for cuf : " + String.valueOf(dataType));
        };
    }

    Expression<?> makePathForTagValueCFV(String alias) {
        return this.makePath(CustomFieldValueOption.class, alias, String.class, "label");
    }

    Expression<?> makePathForNumericValueCFV(String alias) {
        return this.makePath(CustomFieldValue.class, alias, String.class, "numericValue");
    }

    PathBuilder<?> makePathForValueCFV(String alias) {
        return this.makePath(CustomFieldValue.class, alias, String.class, "value");
    }

    SimpleExpression<?> applyOperation(Operation operation, Expression<?> baseExp, Expression<?> ... operands) {
        SimpleOperation result;
        if (operation == Operation.NOT_NULL || operation == Operation.IS_NULL) {
            Operator ops = this.getOperator(operation);
            BooleanOperation nullness = Expressions.predicate((Operator)ops, (Expression[])new Expression[]{baseExp});
            result = Expressions.operation(Boolean.class, (Operator)ExtOps.TRUE_IF, (Expression[])new Expression[]{nullness});
        } else {
            Operator operator = this.getOperator(operation);
            Expression<?>[] expressions = this.prepend(baseExp, operands);
            result = Expressions.operation((Class)operator.getType(), (Operator)operator, expressions);
        }
        return result;
    }

    private SimpleExpression<?> applyOperationForDateCustomFields(Operation operation, Expression<?> baseExp) {
        Expression subStringEnd;
        Ops operator = Ops.SUBSTR_2ARGS;
        Expression subStringBegin = Expressions.constant((Object)0);
        switch (operation) {
            case BY_YEAR: {
                subStringEnd = Expressions.constant((Object)4);
                break;
            }
            case BY_MONTH: {
                subStringEnd = Expressions.constant((Object)7);
                break;
            }
            case BY_DAY: {
                subStringEnd = Expressions.constant((Object)10);
                break;
            }
            case COUNT: {
                operator = ExtOps.S_COUNT;
                return Expressions.operation((Class)operator.getType(), (Operator)operator, (Expression[])new Expression[]{baseExp});
            }
            default: {
                throw new IllegalArgumentException("Unknown operation for date custom field");
            }
        }
        SimpleOperation result = Expressions.operation((Class)operator.getType(), (Operator)operator, (Expression[])new Expression[]{baseExp, subStringBegin, subStringEnd});
        return result;
    }

    BooleanExpression createPredicate(Operation operation, Expression<?> baseExp, DataType datatype, Expression<?> ... operands) {
        return this.doCreatePredicate(operation, baseExp, datatype, null, operands);
    }

    private BooleanExpression doCreatePredicate(Operation operation, Expression<?> baseExp, DataType datatype, QueryFilterColumn filter, Expression<?> ... operands) {
        BooleanExpression predicate;
        if (operation == Operation.NOT_NULL || operation == Operation.IS_NULL) {
            predicate = this.createExistencePredicate(operation, baseExp, operands);
        } else if (datatype == DataType.DATE) {
            predicate = this.createDatePredicate(operation, baseExp, operands);
        } else if (datatype == DataType.ENTITY) {
            predicate = this.createEntityPredicate(operation, baseExp, operands);
        } else if (operation == Operation.MATCHES) {
            predicate = this.createMatchPredicate(baseExp, operands);
        } else if (operation == Operation.FULLTEXT) {
            predicate = this.createFullTextPredicate(baseExp, operands);
        } else if (operation == Operation.LIKE) {
            predicate = this.createLikePredicate(baseExp, operands);
        } else if (operation == Operation.AND) {
            Operator operator = this.getOperator(Operation.IN);
            Expression<?>[] expressions = this.prepend(baseExp, operands);
            predicate = Expressions.predicate((Operator)operator, expressions);
        } else if (operation == Operation.EQUALS && datatype == DataType.STRING && baseExp.getType() != Number.class) {
            predicate = this.createEqualsPredicate(baseExp, operands);
        } else if (operation == Operation.IN && datatype == DataType.NUMERIC && Objects.nonNull(filter)) {
            predicate = this.createInPredicate(operation, baseExp, filter);
        } else {
            Operator operator = this.getOperator(operation);
            Expression<?>[] expressions = this.prepend(baseExp, operands);
            predicate = Expressions.predicate((Operator)operator, expressions);
        }
        return predicate;
    }

    private BooleanExpression createInPredicate(Operation operation, Expression<?> baseExp, QueryFilterColumn filter) {
        Operator operator = this.getOperator(operation);
        List lists = Lists.partition((List)filter.getValues(), (int)5000);
        ArrayDeque stack = new ArrayDeque(lists);
        List first = (List)stack.getFirst();
        BooleanOperation predicate = this.craftSublistPredicate(baseExp, operator, first);
        while (Objects.nonNull(stack.peek())) {
            List list = (List)stack.poll();
            predicate = predicate.or((Predicate)this.craftSublistPredicate(baseExp, operator, list));
        }
        return predicate;
    }

    private BooleanOperation craftSublistPredicate(Expression<?> baseExp, Operator operator, List<String> values) {
        List<Long> numericValues = values.stream().map(Double::parseDouble).map(Double::longValue).toList();
        Expression<?>[] expressions = this.prepend(baseExp, Expressions.constant(numericValues));
        return Expressions.predicate((Operator)operator, expressions);
    }

    private BooleanExpression createExistencePredicate(Operation operation, Expression<?> baseExp, Expression<?> ... operands) {
        String arg = operands[0].toString();
        boolean argIsTrue = "true".equals(arg) || "1".equals(arg);
        boolean isIsNullOperation = operation == Operation.IS_NULL;
        Ops actualOperator = argIsTrue == isIsNullOperation ? Ops.IS_NULL : Ops.IS_NOT_NULL;
        return Expressions.predicate((Operator)actualOperator, (Expression[])new Expression[]{baseExp});
    }

    private BooleanExpression createDatePredicate(Operation operation, Expression<?> baseExp, Expression<?> ... operands) {
        Expression<?> exp = operands[0];
        DateOperation dateOp = Expressions.dateOperation(Date.class, (Operator)Ops.DateTimeOps.DATE, (Expression[])new Expression[]{baseExp});
        return switch (operation) {
            case Operation.EQUALS -> dateOp.eq(exp);
            case Operation.BETWEEN -> dateOp.between(exp, operands[1]);
            case Operation.GREATER -> dateOp.gt(exp);
            case Operation.GREATER_EQUAL -> dateOp.goe(exp);
            case Operation.LOWER -> dateOp.lt(exp);
            case Operation.LOWER_EQUAL -> dateOp.loe(exp);
            case Operation.NOT_EQUALS -> dateOp.ne(exp);
            default -> throw new IllegalArgumentException("Operation '" + String.valueOf(operation) + NOT_YET_SUPPORTED);
        };
    }

    private BooleanExpression createMatchPredicate(Expression<?> baseExp, Expression<?> ... operands) {
        BooleanOperation matchExpr = Expressions.booleanOperation((Operator)ExtOps.S_MATCHES, (Expression[])new Expression[]{baseExp, operands[0]});
        return matchExpr.isTrue();
    }

    private BooleanExpression createFullTextPredicate(Expression<?> baseExp, Expression<?> ... operands) {
        BooleanOperation matchExpr = Expressions.booleanOperation((Operator)ExtOps.FULLTEXT, (Expression[])new Expression[]{baseExp, operands[0]});
        return matchExpr.isTrue();
    }

    private BooleanExpression createLikePredicate(Expression<?> baseExp, Expression<?> ... operands) {
        BooleanOperation matchExpr = Expressions.booleanOperation((Operator)ExtOps.LIKE_INSENSITIVE, (Expression[])new Expression[]{baseExp, operands[0]});
        return matchExpr.isTrue();
    }

    private BooleanExpression createEqualsPredicate(Expression<?> baseExp, Expression<?> ... operands) {
        BooleanOperation matchExpr = Expressions.booleanOperation((Operator)ExtOps.EQUALS_INSENSITIVE, (Expression[])new Expression[]{baseExp, operands[0]});
        return matchExpr.isTrue();
    }

    private BooleanExpression createEntityPredicate(Operation operation, Expression<?> baseExp, Expression<?> ... operands) {
        if (operation != Operation.IS_CLASS && operation != Operation.IN) {
            throw new IllegalArgumentException("Only IS_CLASS and IN operations are allowed for DataType ENTITY.");
        }
        return Expressions.booleanOperation((Operator)ExtOps.IS_CLASS, (Expression[])new Expression[]{baseExp, operands[0]});
    }

    List<Expression<?>> createOperands(QueryFilterColumn filter, Operation operation) {
        QueryColumnPrototype column = filter.getColumn();
        List values = filter.getValues();
        return this.makeOperands(column, operation, values);
    }

    Expression<?> createAsCaseWhen(QueryColumnPrototypeInstance col) {
        if (!col.getDataType().isAssignableToLevelEnum()) {
            throw new IllegalArgumentException("Attempted to create a CaseWhen construct on a non LEVEL_ENUM column");
        }
        CaseBuilder.Cases cases = null;
        Expression<?> colExpr = this.createAsSelect(col);
        EnumHelper helper = new EnumHelper(col.getColumn());
        Map<Level, Integer> levels = helper.getLevelMap();
        for (Map.Entry<Level, Integer> entry : levels.entrySet()) {
            Level enumValue = entry.getKey();
            Integer level = entry.getValue();
            BooleanOperation predicate = Expressions.predicate((Operator)Ops.EQ, (Expression[])new Expression[]{colExpr, Expressions.constant((Object)enumValue)});
            cases = cases == null ? new CaseBuilder().when((Predicate)predicate).then((Number)level) : cases.when((Predicate)predicate).then((Object)level);
        }
        return cases.otherwise((Object)-1000);
    }

    private PathBuilder<?> makePath(Class<?> srcClass, String srcAlias, Class<?> attributeClass, String attributeAlias) {
        return new PathBuilder(srcClass, srcAlias).get(attributeAlias, attributeClass);
    }

    private PathBuilder<?> makePath(Class<?> srcClass, String srcAlias) {
        return new PathBuilder(srcClass, srcAlias);
    }

    private PathBuilder<?> attributePath(QueryColumnPrototypeInstance column) {
        QueryColumnPrototype prototype = column.getColumn();
        InternalEntityType type = InternalEntityType.fromSpecializedType(column.getSpecializedType());
        Class<?> clazz = type.getEntityClass();
        String alias = this.getQName(type);
        if (prototype.representsEntityItself()) {
            return this.makePath(clazz, alias);
        }
        String attribute = prototype.getAttributeName();
        Class<?> attributeType = this.classFromDatatype(prototype.getDataType());
        return this.makePath(clazz, alias, attributeType, attribute);
    }

    List<Expression<?>> makeOperands(QueryColumnPrototype prototype, Operation operation, List<String> values) {
        DataType type = prototype.getDataType();
        try {
            ArrayList expressions = new ArrayList(values.size());
            DataType actualType = operation == Operation.NOT_NULL ? DataType.BOOLEAN : type;
            for (String val : values) {
                Object operand = switch (actualType) {
                    case DataType.STRING, DataType.DATE_AS_STRING, DataType.AUTOMATED_TEST_TECHNOLOGY, DataType.LIST, DataType.INFO_LIST_ITEM, DataType.TAG, DataType.TEXT -> val;
                    case DataType.NUMERIC -> val.contains(".") ? Double.parseDouble(val) : (double)Long.parseLong(val);
                    case DataType.DATE -> DateUtils.parseIso8601Date((String)val);
                    case DataType.LEVEL_ENUM, DataType.REQUIREMENT_STATUS, DataType.EXECUTION_STATUS -> {
                        EnumHelper helper = new EnumHelper(prototype);
                        yield helper.valueOf(val);
                    }
                    case DataType.BOOLEAN_AS_STRING -> val.toLowerCase();
                    case DataType.EXISTENCE, DataType.BOOLEAN -> Boolean.valueOf(val.toLowerCase());
                    case DataType.ENTITY -> this.getOperandForEntity(val);
                    default -> throw new IllegalArgumentException("type '" + String.valueOf(type) + NOT_YET_SUPPORTED);
                };
                if (Operation.LIKE == operation && !operand.toString().contains("%")) {
                    operand = "%" + operand.toString() + "%";
                }
                expressions.add(Expressions.constant((Object)operand));
            }
            if (operation == Operation.IN || operation == Operation.AND) {
                ArrayList listeExpression = new ArrayList(1);
                listeExpression.add(ExpressionUtils.list(Object.class, (Expression[])expressions.toArray(new Expression[expressions.size()])));
                return listeExpression;
            }
            return expressions;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object getOperandForEntity(String val) {
        try {
            return Class.forName(val);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private Operator getOperator(Operation operation) {
        return switch (operation) {
            case Operation.EQUALS -> Ops.EQ;
            case Operation.LIKE -> Ops.LIKE;
            case Operation.BY_DAY -> ExtOps.YEAR_MONTH_DAY;
            case Operation.BY_WEEK -> Ops.DateTimeOps.YEAR_WEEK;
            case Operation.BY_MONTH -> Ops.DateTimeOps.YEAR_MONTH;
            case Operation.BY_YEAR -> Ops.DateTimeOps.YEAR;
            case Operation.COUNT -> ExtOps.S_COUNT;
            case Operation.SUM -> ExtOps.S_SUM;
            case Operation.GREATER -> Ops.GT;
            case Operation.IN -> Ops.IN;
            case Operation.BETWEEN -> Ops.BETWEEN;
            case Operation.AVG -> ExtOps.S_AVG;
            case Operation.GREATER_EQUAL -> Ops.GOE;
            case Operation.LOWER -> Ops.LT;
            case Operation.LOWER_EQUAL -> Ops.LOE;
            case Operation.MAX -> ExtOps.S_MAX;
            case Operation.MIN -> ExtOps.S_MIN;
            case Operation.IS_NULL -> Ops.IS_NULL;
            case Operation.NOT_NULL -> Ops.IS_NOT_NULL;
            case Operation.NOT_EQUALS -> Ops.NE;
            case Operation.FULLTEXT -> ExtOps.FULLTEXT;
            default -> throw new IllegalArgumentException("Operation '" + String.valueOf(operation) + NOT_YET_SUPPORTED);
        };
    }

    private Expression<?>[] prepend(Expression<?> head, Expression<?> ... tail) {
        Expression[] res = new Expression[tail.length + 1];
        res[0] = head;
        System.arraycopy(tail, 0, res, 1, tail.length);
        return res;
    }

    private Class<?> classFromDatatype(DataType type) {
        return switch (type) {
            case DataType.DATE -> Date.class;
            case DataType.STRING, DataType.TEXT -> String.class;
            case DataType.NUMERIC -> Long.class;
            case DataType.EXECUTION_STATUS -> ExecutionStatus.class;
            case DataType.AUTOMATED_TEST_TECHNOLOGY -> AutomatedTestTechnology.class;
            case DataType.INFO_LIST_ITEM -> InfoListItem.class;
            case DataType.REQUIREMENT_STATUS -> RequirementStatus.class;
            case DataType.LEVEL_ENUM -> Level.class;
            case DataType.BOOLEAN -> Boolean.class;
            default -> throw new IllegalArgumentException("datatype '" + String.valueOf(type) + "' is not yet supported");
        };
    }

    private QueryStrategy subQueryStrategy(QueryColumnPrototypeInstance col) {
        QueryColumnPrototype proto = col.getColumn();
        if (proto.getColumnType() != ColumnType.CALCULATED) {
            throw new IllegalArgumentException("column '" + proto.getLabel() + "' has a column type of '" + String.valueOf(proto.getColumnType()) + "', therefore it has no subquery");
        }
        return proto.getSubQuery().getStrategy();
    }

    private static final class AliasCollector
    implements Visitor<Void, Set<String>> {
        private Set<String> aliases = new HashSet<String>();

        private AliasCollector() {
        }

        public Void visit(Constant<?> expr, Set<String> context) {
            return null;
        }

        public Void visit(FactoryExpression<?> expr, Set<String> context) {
            return null;
        }

        public Void visit(com.querydsl.core.types.Operation<?> expr, Set<String> context) {
            for (Expression subexpr : expr.getArgs()) {
                subexpr.accept((Visitor)this, context);
            }
            return null;
        }

        public Void visit(ParamExpression<?> expr, Set<String> context) {
            return null;
        }

        public Void visit(Path<?> expr, Set<String> context) {
            PathMetadata metadata = expr.getMetadata();
            if (metadata.isRoot()) {
                context.add(expr.getMetadata().getName());
            } else {
                metadata.getParent().accept((Visitor)this, context);
            }
            return null;
        }

        public Void visit(SubQueryExpression<?> expr, Set<String> context) {
            return null;
        }

        public Void visit(TemplateExpression<?> expr, Set<String> context) {
            return null;
        }

        Set<String> getAliases() {
            return this.aliases;
        }
    }
}

