/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotImportFileException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotReadImportFileException;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ParentPivotEntity;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoader;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoaderFactory;

public abstract class AbstractPivotImport {
    protected static final int POST_CREATE_BATCH_SIZE = 100;
    private final Logger logger;

    protected AbstractPivotImport(Logger logger) {
        this.logger = logger;
    }

    /*
     * Unable to fully structure code
     */
    protected <IS extends InputStream, P extends AbstractPivotObject> void parseEntities(IS is, JsonImportFile jsonImportFile, String entityKind, Class<P> pivotClazz, Consumer<P> parsingStrategy) {
        objectMapper = new ObjectMapper();
        try {
            var7_7 = null;
            var8_10 = null;
            try {
                jsonParser = objectMapper.createParser(is);
                try {
                    jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                    while (jsonParser.nextToken() != null) {
                        if (jsonImportFile.getJsonFieldKind().equals(jsonParser.currentName())) ** GOTO lbl14
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            this.parseEntity(objectMapper, jsonParser, entityKind, pivotClazz, parsingStrategy);
lbl14:
                            // 2 sources

                            ** while (jsonParser.nextToken() != null)
                        }
lbl15:
                        // 1 sources

                    }
                }
                finally {
                    if (jsonParser != null) {
                        jsonParser.close();
                    }
                }
            }
            catch (Throwable var8_11) {
                if (var7_7 == null) {
                    var7_7 = var8_11;
                } else if (var7_7 != var8_11) {
                    var7_7.addSuppressed(var8_11);
                }
                throw var7_7;
            }
        }
        catch (IOException e) {
            this.logger.error("Error while parsing entity json", (Throwable)e);
            throw new CouldNotReadImportFileException();
        }
    }

    protected <P extends AbstractPivotObject> void parseEntities(ZipFile zipFile, JsonImportFile jsonImportFile, String entityKind, Class<P> pivotClazz, Consumer<P> parsingStrategy) {
        ZipEntry entry = zipFile.getEntry(jsonImportFile.getFileName());
        if (Objects.isNull(entry)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream zis = zipFile.getInputStream(entry);){
                this.parseEntities(zis, jsonImportFile, entityKind, pivotClazz, parsingStrategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Error while reading {} from zip file", new Object[]{jsonImportFile.getFileName(), e});
            throw new CouldNotReadImportFileException();
        }
    }

    private <P extends AbstractPivotObject> void parseEntity(ObjectMapper objectMapper, JsonParser jsonParser, String entityKind, Class<P> pivotClazz, Consumer<P> parsingStrategy) throws IOException {
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            return;
        }
        JsonNode node = (JsonNode)objectMapper.readTree(jsonParser);
        JsonNode pivotIdNode = node.get("id");
        try {
            AbstractPivotObject pivotObject = (AbstractPivotObject)objectMapper.treeToValue((TreeNode)node, pivotClazz);
            PivotFormatLoggerHelper.logParsingSuccessForEntity(this.logger, entityKind, pivotObject.getPivotId());
            parsingStrategy.accept(pivotObject);
        }
        catch (Exception e) {
            String pivotId = null;
            if (pivotIdNode != null) {
                pivotId = pivotIdNode.asText();
            }
            PivotFormatLoggerHelper.handleParsingErrorForEntity(this.logger, entityKind, pivotId, e);
        }
    }

    protected <P extends AbstractPivotObject> void importEntitiesFromZipArchive(ZipFile zipFile, JsonImportFile jsonImportFile, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata, String entitiesKind, String entityKind, PivotImportStrategy<P> pivotImportStrategy) {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(this.logger, zipFile.getName(), entitiesKind, pivotFormatImport);
        pivotImportMetadata.setCurrentImportFile(jsonImportFile);
        ZipEntry entry = zipFile.getEntry(jsonImportFile.getFileName());
        if (Objects.isNull(entry)) {
            pivotImportStrategy.onMissingFile();
            return;
        }
        pivotImportMetadata.setAtLeastOneData(true);
        ArrayList entities = new ArrayList();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                this.parseEntities(jsonInputStream, jsonImportFile, entityKind, pivotImportStrategy.getPivotClazz(), (P entity) -> {
                    entities.add(entity);
                    if (entities.size() == 50) {
                        pivotImportMetadata.clearTransientData();
                        pivotImportStrategy.create(entities);
                    }
                });
                if (!entities.isEmpty()) {
                    pivotImportMetadata.clearTransientData();
                    pivotImportStrategy.create(entities);
                }
                pivotImportStrategy.postCreate();
                PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(this.logger, entitiesKind, pivotFormatImport);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.logImportFailureForEntitiesKind(this.logger, entitiesKind, pivotFormatImport);
            throw new CouldNotImportFileException("Could not import file %s".formatted(jsonImportFile.getFileName()), e);
        }
    }

    protected <E extends ParentPivotEntity> void createEntities(List<E> entities, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, ContainerLoaderFactory containerLoaderFactory, Function<E, EntityType> parentTypeFunction, BiConsumer<E, ContainerLoader> entityCreator) {
        entities.stream().collect(Collectors.groupingBy(parentTypeFunction, LinkedHashMap::new, Collectors.toList())).forEach((parentType, groupedEntities) -> {
            ContainerLoader containerLoader = containerLoaderFactory.loadContainers((EntityType)parentType, groupedEntities, projectIdsReferences, pivotImportMetadata);
            groupedEntities.forEach(entity -> entityCreator.accept(entity, containerLoader));
        });
    }

    protected <E extends ParentPivotEntity> void createEntities(List<E> entities, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, ContainerLoaderFactory containerLoaderFactory, BiConsumer<E, ContainerLoader> entityCreator) {
        this.createEntities(entities, projectIdsReferences, pivotImportMetadata, containerLoaderFactory, ParentPivotEntity::getParentType, entityCreator);
    }

    protected <T extends org.squashtest.tm.domain.library.TreeNode> void fixConflictNames(NodeContainer<T> container, String name, Consumer<String> nameSetter) {
        String newName = LibraryUtils.generateNonClashingName(name, container.getContentNames(), 255);
        if (!newName.equals(name)) {
            nameSetter.accept(newName);
        }
    }

    protected void handleCustomFields(PrivateCustomFieldValueService customFieldValueService, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<BoundEntity, Map<Long, RawValue>> boundEntities = pivotImportMetadata.getCufByEntity();
        if (boundEntities.isEmpty()) {
            return;
        }
        customFieldValueService.createAllCustomFieldValues(boundEntities.keySet(), (GenericProject)pivotFormatImport.getProject(), boundEntities, pivotImportMetadata.getBaseUrl());
        boundEntities.clear();
    }
}

