/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.RequirementLinkDao;
import org.squashtest.tm.service.pivot.projectexporter.RequirementLinkExporterService;

@Service
public class RequirementLinkExporterServiceImpl
implements RequirementLinkExporterService {
    private final PivotFileManager pivotFileManager;
    private final RequirementLinkDao requirementLinkDao;

    public RequirementLinkExporterServiceImpl(PivotFileManager pivotFileManager, RequirementLinkDao requirementLinkDao) {
        this.pivotFileManager = pivotFileManager;
        this.requirementLinkDao = requirementLinkDao;
    }

    @Override
    public void generateRequirementLinkJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.requirementLinkDao.hasRequirementLinkByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleRequirementLink((JsonGenerator)jsonGenerator, projectId), JsonImportFile.REQUIREMENT_LINK_TYPES, archive);
    }

    private void handleRequirementLink(JsonGenerator jsonGenerator, Long projectId) {
        this.requirementLinkDao.getRequirementLinkByProjectId(projectId, requirementLinkTypePivot -> this.pivotFileManager.writePivotObject(requirementLinkTypePivot, jsonGenerator, JsonImportFile.REQUIREMENT_LINK_TYPES));
    }
}

