/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.license;

import org.springframework.stereotype.Service;
import org.squashtest.tm.exception.NotAllowedByLicenseException;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.license.LicenseHelperService;

@Service(value="LicenseHelperService")
public class LicenseHelperServiceImpl
implements LicenseHelperService {
    private final ConfigurationService configurationService;

    public LicenseHelperServiceImpl(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public boolean licenseAllowsToAddOrActivateUser() {
        String userLicenseInformation = this.getRawUserLicenseInformation();
        return userLicenseInformation == null || !userLicenseInformation.contains("false");
    }

    @Override
    public void assertLicenseAllowsToAddOrActivateUser() {
        if (!this.licenseAllowsToAddOrActivateUser()) {
            throw new NotAllowedByLicenseException();
        }
    }

    private String getRawUserLicenseInformation() {
        return this.configurationService.findConfiguration("activated.user.excess");
    }
}

