/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionStepCollector;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.IsKeywordTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.library.PasteOperation;
import org.squashtest.tm.service.internal.library.TreeNodeUpdater;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Component
@Scope(value="prototype")
public class TreeNodeCopier
implements NodeVisitor,
PasteOperation {
    private static final String UNCHECKED = "unchecked";
    private static final String RAWTYPES = "rawtypes";
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementFolderDao requirementFolderDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private CampaignFolderDao campaignFolderDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private PrivateCustomFieldValueService customFieldValueManagerService;
    @Inject
    private TreeNodeUpdater treeNodeUpdater;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private RequirementVersionCoverageDao requirementVersionCoverageDao;
    @Inject
    private RequirementVersionLinkDao requirementVersionLinkDao;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private MessageSource messageSource;
    @PersistenceContext
    private EntityManager entityManager;
    private NodeContainer<? extends TreeNode> destination;
    private TreeNode copy;
    private boolean okToGoDeeper = true;
    private boolean projectChanged = true;
    private int batchRequirement = 0;

    @Override
    public TreeNode performOperation(TreeNode source, NodeContainer<TreeNode> destination, Integer position) {
        this.permissionService.checkPermission(new SecurityCheckableObject(destination, Permissions.CREATE.name()), new SecurityCheckableObject(source, Permissions.READ.name()));
        this.okToGoDeeper = true;
        this.destination = destination;
        this.projectChanged = this.projectchanged(source);
        this.copy = null;
        source.accept((NodeVisitor)this);
        if (this.projectChanged) {
            this.flush();
            this.copy.accept((NodeVisitor)this.treeNodeUpdater);
        }
        return this.copy;
    }

    @Override
    public TreeNode performOperationFromReqToTc(TreeNode source, TreeNode transformed, NodeContainer<TreeNode> destination, Integer position) {
        this.permissionService.checkPermission(new SecurityCheckableObject(destination, Permissions.CREATE.name()), new SecurityCheckableObject(source, Permissions.READ.name()));
        this.okToGoDeeper = true;
        this.destination = destination;
        this.projectChanged = this.projectchanged(source);
        this.copy = null;
        transformed.accept((NodeVisitor)this);
        if (this.projectChanged) {
            this.flush();
            this.copy.accept((NodeVisitor)this.treeNodeUpdater);
        }
        return this.copy;
    }

    private boolean projectchanged(TreeNode source) {
        Project projectSource = source.getProject();
        GenericProject projectDestination = this.destination.getProject();
        return projectSource != null && projectDestination != null && !projectSource.getId().equals(projectDestination.getId());
    }

    public void visit(Folder source, FolderDao dao) {
        Folder copyFolder = (Folder)source.createCopy();
        this.persistCopy(copyFolder, dao, 255);
        this.copyCustomFields((BoundEntity)source, (BoundEntity)copyFolder);
        this.copyContentsOnExternalRepository((AttachmentHolder)copyFolder);
        this.updateLibraryContentAttachmentSrc((LibraryNode)source, (LibraryNode)copyFolder);
    }

    public void visit(Campaign source) {
        Campaign copyCampaign = source.createCopy();
        this.persistCopy(copyCampaign, this.campaignDao, 255);
        this.copyCustomFields((BoundEntity)source, (BoundEntity)copyCampaign);
        this.copyContentsOnExternalRepository((AttachmentHolder)copyCampaign);
        this.updateLibraryContentAttachmentSrc((LibraryNode)source, (LibraryNode)copyCampaign);
    }

    public void visit(Iteration source) {
        Iteration copyIteration = source.createCopy();
        this.persitIteration(copyIteration);
        this.copyCustomFields(source, copyIteration);
        this.copyContentsOnExternalRepository((AttachmentHolder)copyIteration);
        this.updateIterationContentAttachmentSrc(source, copyIteration);
        this.okToGoDeeper = false;
    }

    public void visit(TestSuite source) {
        TestSuite copyTestSuite = source.createCopy();
        this.persistCopy(copyTestSuite, this.testSuiteDao, 255);
        this.copyCustomFields((BoundEntity)source, (BoundEntity)copyTestSuite);
        this.copyTestSuiteTestPlanToDestinationIteration(source, copyTestSuite);
        this.copyContentsOnExternalRepository((AttachmentHolder)copyTestSuite);
        this.updateTestSuiteContentAttachmentSrc(source, copyTestSuite);
    }

    public void visit(Sprint sprint) {
        Sprint sprintCopy = sprint.createCopy();
        this.persistCopy(sprintCopy, this.sprintDao, 255);
        this.copyCustomFields((BoundEntity)sprint, (BoundEntity)sprintCopy);
        this.copyContentsOnExternalRepository((AttachmentHolder)sprintCopy);
        this.updateLibraryContentAttachmentSrc((LibraryNode)sprint, (LibraryNode)sprintCopy);
    }

    public void visit(SprintGroup sprintGroup) {
        SprintGroup sprintGroupCopy = sprintGroup.createCopy();
        this.persistCopy(sprintGroupCopy, this.sprintGroupDao, 255);
        this.copyCustomFields((BoundEntity)sprintGroup, (BoundEntity)sprintGroupCopy);
        this.copyContentsOnExternalRepository((AttachmentHolder)sprintGroup);
        this.updateLibraryContentAttachmentSrc((LibraryNode)sprintGroup, (LibraryNode)sprintGroupCopy);
    }

    private void copyTestSuiteTestPlanToDestinationIteration(TestSuite source, TestSuite copy) {
        Iteration iteration = (Iteration)this.destination;
        List itemsToCopy = source.getTestPlanItems();
        List copiedItems = iteration.getTestPlan().copyItems(itemsToCopy);
        copy.bindTestPlanItems(copiedItems);
    }

    public void visit(Requirement source) {
        Requirement copyRequirement = source.createCopy();
        SortedMap previousVersionsCopiesBySources = source.addPreviousVersionsCopiesToCopy(copyRequirement);
        this.persistCopy(copyRequirement, this.requirementDao, 255);
        this.copyCustomFields((BoundEntity)source.getCurrentVersion(), (BoundEntity)copyRequirement.getCurrentVersion());
        this.copyRequirementVersionCoverages(source.getCurrentVersion(), copyRequirement.getCurrentVersion());
        this.copyRequirementVersionLinks(source.getCurrentVersion(), copyRequirement.getCurrentVersion());
        this.copyContentsOnExternalRepository((AttachmentHolder)copyRequirement.getCurrentVersion());
        this.copyCustomFieldsAndReqVersionForOlderVersions(previousVersionsCopiesBySources);
        this.updateLibraryContentAttachmentSrc((LibraryNode)source, (LibraryNode)copyRequirement);
        this.updateHighLevelRequirementReference(source, copyRequirement);
        ++this.batchRequirement;
        if (this.batchRequirement % 10 == 0) {
            this.flush();
        }
    }

    public void visit(HighLevelRequirement source) {
        HighLevelRequirement copyRequirement = source.createCopy();
        SortedMap previousVersionsCopiesBySources = source.addPreviousVersionsCopiesToCopy((Requirement)copyRequirement);
        this.persistCopy((TreeNode)copyRequirement, this.requirementDao, 255);
        this.copyCustomFields((BoundEntity)source.getCurrentVersion(), (BoundEntity)copyRequirement.getCurrentVersion());
        this.copyRequirementVersionCoverages(source.getCurrentVersion(), copyRequirement.getCurrentVersion());
        this.copyRequirementVersionLinks(source.getCurrentVersion(), copyRequirement.getCurrentVersion());
        this.copyContentsOnExternalRepository((AttachmentHolder)copyRequirement.getCurrentVersion());
        this.copyCustomFieldsAndReqVersionForOlderVersions(previousVersionsCopiesBySources);
        this.updateLibraryContentAttachmentSrc((LibraryNode)source, (LibraryNode)copyRequirement);
        ++this.batchRequirement;
        if (this.batchRequirement % 10 == 0) {
            this.flush();
        }
    }

    private void copyCustomFieldsAndReqVersionForOlderVersions(SortedMap<RequirementVersion, RequirementVersion> previousVersionsCopiesBySources) {
        for (Map.Entry<RequirementVersion, RequirementVersion> previousVersionCopyBySource : previousVersionsCopiesBySources.entrySet()) {
            RequirementVersion sourceVersion = previousVersionCopyBySource.getKey();
            RequirementVersion copyVersion = previousVersionCopyBySource.getValue();
            this.copyRequirementVersionCoverages(sourceVersion, copyVersion);
            this.copyRequirementVersionLinks(sourceVersion, copyVersion);
            this.copyCustomFields((BoundEntity)sourceVersion, (BoundEntity)copyVersion);
            this.copyContentsOnExternalRepository((AttachmentHolder)copyVersion);
        }
    }

    private void updateHighLevelRequirementReference(Requirement source, Requirement copyRequirement) {
        Long parentReqId = this.requirementDao.findRequirementAncestorId(copyRequirement.getId());
        if (parentReqId != null) {
            this.updateHighLvlReqReferenceWithExistingAncestor(source, copyRequirement, parentReqId);
        } else {
            copyRequirement.setHighLevelRequirement(source.getHighLevelRequirement());
        }
    }

    private void updateHighLvlReqReferenceWithExistingAncestor(Requirement source, Requirement copyRequirement, Long parentReqId) {
        Requirement parent = (Requirement)this.requirementDao.findById(parentReqId);
        if (parent != null) {
            this.updateHighLvlReqReferenceWithReqAncestor(parent, copyRequirement);
        } else {
            copyRequirement.setHighLevelRequirement(source.getHighLevelRequirement());
        }
    }

    private void updateHighLvlReqReferenceWithReqAncestor(Requirement parent, Requirement copyRequirement) {
        if (parent.isHighLevel()) {
            copyRequirement.setHighLevelRequirement((HighLevelRequirement)parent);
        } else {
            copyRequirement.setHighLevelRequirement(parent.getHighLevelRequirement());
        }
    }

    public void visit(TestCase source) {
        TestCase copyTestCase = source.createCopy();
        this.persistTestCase(copyTestCase);
        this.copyRequirementVersionCoverage(source, copyTestCase);
        this.copyContentsOnExternalRepository((AttachmentHolder)copyTestCase);
        IsKeywordTestCaseVisitor visitor = new IsKeywordTestCaseVisitor();
        source.accept((TestCaseVisitor)visitor);
        this.copyCustomFields(source, copyTestCase);
        if (!visitor.isKeyword()) {
            copyTestCase.getActionSteps().forEach(this::copyContentsOnExternalRepository);
        }
        this.updateLibraryContentAttachmentSrc((LibraryNode)source, (LibraryNode)copyTestCase);
        ++this.batchRequirement;
        if (this.batchRequirement % 10 == 0) {
            this.flush();
        }
    }

    private void updateLibraryContentAttachmentSrc(LibraryNode source, LibraryNode copy) {
        String updatedDescription;
        String description = copy.getDescription();
        if (description != null && !description.isEmpty() && !description.equals(updatedDescription = this.attachmentManagerService.handleRichTextAttachments(source.getAttachmentList(), copy.getAttachmentList(), description))) {
            if (copy instanceof Requirement) {
                Requirement requirementCopy = (Requirement)copy;
                requirementCopy.updateDescriptionAttachmentLinkOnCopy(updatedDescription);
            } else {
                copy.setDescription(updatedDescription);
            }
        }
        if (source instanceof TestCase) {
            TestCase testCaseSource = (TestCase)source;
            this.updateActionStepsAttachmentsSrc(testCaseSource, (TestCase)copy);
        }
    }

    private void updateActionStepsAttachmentsSrc(TestCase sourceTestCase, TestCase copy) {
        List sourceActionSteps = sourceTestCase.getActionSteps();
        List copyActionSteps = copy.getActionSteps();
        int i = 0;
        while (i < sourceActionSteps.size()) {
            ActionTestStep sourceActionStep = (ActionTestStep)sourceActionSteps.get(i);
            ActionTestStep copyActionStep = (ActionTestStep)copyActionSteps.get(i);
            String updateAction = this.attachmentManagerService.handleRichTextAttachments(sourceActionStep.getAttachmentList(), copyActionStep.getAttachmentList(), copyActionStep.getAction());
            String updatedExpectedResult = this.attachmentManagerService.handleRichTextAttachments(sourceActionStep.getAttachmentList(), copyActionStep.getAttachmentList(), copyActionStep.getExpectedResult());
            copyActionStep.setAction(updateAction);
            copyActionStep.setExpectedResult(updatedExpectedResult);
            ++i;
        }
    }

    private void updateTestSuiteContentAttachmentSrc(TestSuite source, TestSuite copy) {
        String description = copy.getDescription();
        if (description != null && !description.isEmpty()) {
            String updatedDescription = this.attachmentManagerService.handleRichTextAttachments(source.getAttachmentList(), copy.getAttachmentList(), description);
            copy.setDescription(updatedDescription);
        }
    }

    private void updateIterationContentAttachmentSrc(Iteration source, Iteration copy) {
        String description = copy.getDescription();
        if (description != null && !description.isEmpty()) {
            String updatedDescription = this.attachmentManagerService.handleRichTextAttachments(source.getAttachmentList(), copy.getAttachmentList(), description);
            copy.setDescription(updatedDescription);
        }
    }

    public void visit(CampaignFolder campaignFolder) {
        this.visit((Folder)campaignFolder, this.campaignFolderDao);
    }

    public void visit(RequirementFolder requirementFolder) {
        this.visit((Folder)requirementFolder, this.requirementFolderDao);
    }

    public void visit(TestCaseFolder testCaseFolder) {
        this.visit((Folder)testCaseFolder, this.testCaseFolderDao);
    }

    private void copyCustomFields(Iteration original, Iteration copy) {
        this.customFieldValueManagerService.copyCustomFieldValues((BoundEntity)original, (BoundEntity)copy);
        for (TestSuite originaTestSuite : original.getTestSuites()) {
            TestSuite copyTestSuite = copy.getTestSuiteByName(originaTestSuite.getName());
            if (this.projectChanged) {
                this.updateCustomFieldValues((BoundEntity)originaTestSuite, (BoundEntity)copyTestSuite);
                continue;
            }
            this.customFieldValueManagerService.copyCustomFieldValuesContent((BoundEntity)originaTestSuite, (BoundEntity)copyTestSuite);
        }
    }

    private void updateCustomFieldValues(BoundEntity original, BoundEntity copy) {
        List<CustomFieldValue> originalCfvs = this.customFieldValueManagerService.findAllCustomFieldValues(original);
        if (originalCfvs.isEmpty()) {
            return;
        }
        block0: for (CustomFieldValue cfv : this.customFieldValueManagerService.findAllCustomFieldValues(copy)) {
            for (CustomFieldValue origCfv : this.customFieldValueManagerService.findAllCustomFieldValues(original)) {
                if (!cfv.getCufId().equals(origCfv.getCufId())) continue;
                cfv.setValue(origCfv.getValue());
                continue block0;
            }
        }
    }

    private void copyCustomFields(BoundEntity source, BoundEntity copy) {
        this.customFieldValueManagerService.copyCustomFieldValues(source, copy);
    }

    private void copyCustomFields(TestCase source, TestCase copy) {
        this.customFieldValueManagerService.copyCustomFieldValues((BoundEntity)source, (BoundEntity)copy);
        ActionStepCollector collector = new ActionStepCollector();
        List copySteps = collector.collect(copy.getSteps());
        List sourceSteps = collector.collect(source.getSteps());
        int total = copySteps.size();
        HashMap<Long, BoundEntity> copiedStepsIdsBySource = new HashMap<Long, BoundEntity>(total);
        int i = 0;
        while (i < total) {
            ActionTestStep copyStep = (ActionTestStep)copySteps.get(i);
            ActionTestStep sourceStep = (ActionTestStep)sourceSteps.get(i);
            copiedStepsIdsBySource.put(sourceStep.getId(), (BoundEntity)copyStep);
            ++i;
        }
        this.customFieldValueManagerService.copyCustomFieldValues(copiedStepsIdsBySource, BindableEntity.TEST_STEP);
    }

    private <T extends TreeNode> void persistCopy(T copyParam, EntityDao<T> dao, int nameMaxSize) {
        this.renameIfNeeded((Copiable)copyParam, nameMaxSize);
        dao.persist(copyParam);
        this.destination.addContent(copyParam);
        this.copy = copyParam;
    }

    private <T extends TreeNode> void persistCopy(T copyParam, JpaRepository<T, Long> dao, int nameMaxSize) {
        this.renameIfNeeded((Copiable)copyParam, nameMaxSize);
        dao.save(copyParam);
        this.destination.addContent(copyParam);
        this.copy = copyParam;
    }

    private void persistTestCase(TestCase testCase) {
        this.renameIfNeeded(testCase, 255);
        this.testCaseDao.persistTestCaseAndSteps(testCase);
        this.destination.addContent((TreeNode)testCase);
        this.copy = testCase;
    }

    private void persitIteration(Iteration copyParam) {
        this.renameIfNeeded(copyParam, 255);
        this.iterationDao.persist(copyParam);
        this.destination.addContent((TreeNode)copyParam);
        this.copy = copyParam;
    }

    private <T extends Copiable> void renameIfNeeded(T copyParam, int maxNameSize) {
        if (!this.destination.isContentNameAvailable(copyParam.getName())) {
            String suffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
            String newName = LibraryUtils.generateUniqueCopyName(this.destination.getContentNames(), copyParam.getName(), maxNameSize, suffix);
            copyParam.setName(newName);
        }
    }

    @Override
    public boolean isOkToGoDeeper() {
        return this.okToGoDeeper;
    }

    private void copyRequirementVersionCoverages(RequirementVersion sourceVersion, RequirementVersion copyVersion) {
        List copies = sourceVersion.createRequirementVersionCoveragesForCopy(copyVersion);
        this.requirementVersionCoverageDao.persist(copies);
    }

    private void copyRequirementVersionLinks(RequirementVersion sourceVersion, RequirementVersion copyVersion) {
        List copies = sourceVersion.createRequirementVersionLinksForCopy(copyVersion);
        this.requirementVersionLinkDao.addLinks(copies);
    }

    private void copyRequirementVersionCoverage(TestCase source, TestCase copyTestCase) {
        List copies = source.createRequirementVersionCoveragesForCopy(copyTestCase);
        this.requirementVersionCoverageDao.persist(copies);
    }

    private void flush() {
        this.entityManager.flush();
    }

    private void copyContentsOnExternalRepository(AttachmentHolder attachmentHolder) {
        this.attachmentManagerService.copyContentsOnExternalRepository(attachmentHolder);
    }
}

