/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.XlsEntityKind;
import org.squashtest.tm.exception.xlsimport.MaxConcurrentImportsReachedException;
import org.squashtest.tm.exception.xlsimport.MaxItemsPerImportExceededException;
import org.squashtest.tm.service.importer.XlsImportLimitationHandler;

@Service(value="XlsImportLimitationHandler")
public class XlsImportLimitationHandlerImpl
implements XlsImportLimitationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsImportLimitationHandlerImpl.class);
    public static final AtomicInteger IMPORT_PROCESS_COUNTER = new AtomicInteger(0);
    @Value(value="${squash.xls-imports.max-concurrent-imports:#{null}}")
    Integer maxConcurrentImports;
    @Value(value="${squash.xls-imports.max-test-cases-per-import:#{null}}")
    Integer maxTestCasesPerImport;
    @Value(value="${squash.xls-imports.max-test-steps-per-import:#{null}}")
    Integer maxTestStepsPerImport;
    @Value(value="${squash.xls-imports.max-requirements-per-import:#{null}}")
    Integer maxRequirementsPerImport;

    @Override
    public void checkIfImportSlotIsAvailable() {
        if (Objects.nonNull(this.maxConcurrentImports) && IMPORT_PROCESS_COUNTER.get() > this.maxConcurrentImports) {
            String message = String.format("The maximum number of concurrent imports (%s) has been reached. Please try again later.", this.maxConcurrentImports);
            LOGGER.error(message, new Object[0]);
            throw new MaxConcurrentImportsReachedException(message);
        }
    }

    @Override
    public void incrementImportProcessCounter() {
        IMPORT_PROCESS_COUNTER.incrementAndGet();
    }

    @Override
    public void decrementImportProcessCounter() {
        IMPORT_PROCESS_COUNTER.decrementAndGet();
    }

    @Override
    public void checkMaxNumberOfTestCasesInsideXlsFile(File excelFile) {
        if (Objects.isNull(this.maxTestCasesPerImport)) {
            return;
        }
        int rowsInXlsFile = this.getXlsSheetRowCount(excelFile, 0);
        if (rowsInXlsFile > this.maxTestCasesPerImport) {
            String message = String.format("The number of test cases in the Excel file (%d) exceeds the maximum allowed (%d).", rowsInXlsFile, this.maxTestCasesPerImport);
            LOGGER.error(message, new Object[0]);
            throw new MaxItemsPerImportExceededException(XlsEntityKind.TEST_CASES, rowsInXlsFile, this.maxTestCasesPerImport.intValue(), message);
        }
    }

    @Override
    public void checkMaxNumberOfTestStepsInsideXlsFile(File excelFile) {
        if (Objects.isNull(this.maxTestStepsPerImport)) {
            return;
        }
        int rowsInXlsFile = this.getXlsSheetRowCount(excelFile, 1);
        if (rowsInXlsFile > this.maxTestStepsPerImport) {
            String message = String.format("The number of test steps in the Excel file (%d) exceeds the maximum allowed (%d).", rowsInXlsFile, this.maxTestStepsPerImport);
            LOGGER.error(message, new Object[0]);
            throw new MaxItemsPerImportExceededException(XlsEntityKind.TEST_STEPS, rowsInXlsFile, this.maxTestStepsPerImport.intValue(), message);
        }
    }

    @Override
    public void checkMaxNumberOfRequirementsInsideXlsFile(File excelFile) {
        if (Objects.isNull(this.maxRequirementsPerImport)) {
            return;
        }
        int rowsInXlsFile = this.getXlsSheetRowCount(excelFile, 0);
        if (rowsInXlsFile > this.maxRequirementsPerImport) {
            String message = String.format("The number of requirements in the Excel file (%d) exceeds the maximum allowed (%d).", rowsInXlsFile, this.maxRequirementsPerImport);
            LOGGER.error(message, new Object[0]);
            throw new MaxItemsPerImportExceededException(XlsEntityKind.REQUIREMENTS, rowsInXlsFile, this.maxRequirementsPerImport.intValue(), message);
        }
    }

    private int getXlsSheetRowCount(File excelFile, int sheetIndex) {
        int lineCount = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Workbook workbook = WorkbookFactory.create((File)excelFile);){
                Sheet sheet = workbook.getSheetAt(sheetIndex);
                sheet.iterator();
                lineCount = this.getNonEmptyRowCount(sheet);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to count the number of imported entities in the Excel file ", (Throwable)e);
        }
        return lineCount - 1;
    }

    private int getNonEmptyRowCount(Sheet sheet) {
        int nonEmptyRowCount = 0;
        int i = sheet.getFirstRowNum();
        while (i <= sheet.getLastRowNum()) {
            boolean rowEmpty = true;
            Row row = sheet.getRow(i);
            if (row != null) {
                int j = row.getFirstCellNum();
                while (j < row.getLastCellNum()) {
                    Cell cell = row.getCell(j);
                    if (cell != null && cell.getCellType() != CellType.BLANK) {
                        rowEmpty = false;
                        break;
                    }
                    ++j;
                }
            }
            if (!rowEmpty) {
                ++nonEmptyRowCount;
            }
            ++i;
        }
        return nonEmptyRowCount;
    }
}

