/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.execution.IssueHolder;
import org.squashtest.tm.service.execution.SessionNoteService;
import org.squashtest.tm.service.internal.bugtracker.RemoteIssueContextHelper;
import org.squashtest.tm.service.internal.repository.SessionNoteDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional(readOnly=true)
public class SessionNoteServiceImpl
implements SessionNoteService,
IssueHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNoteServiceImpl.class);
    private final SessionNoteDisplayDao sessionNoteDisplayDao;
    private final SessionNoteDao sessionNoteDao;
    private final PermissionEvaluationService permissionService;
    private final SprintManagerService sprintManagerService;
    @PersistenceContext
    private EntityManager em;

    public SessionNoteServiceImpl(SessionNoteDisplayDao sessionNoteDisplayDao, SessionNoteDao sessionNoteDao, PermissionEvaluationService permissionService, SprintManagerService sprintManagerService) {
        this.sessionNoteDisplayDao = sessionNoteDisplayDao;
        this.sessionNoteDao = sessionNoteDao;
        this.permissionService = permissionService;
        this.sprintManagerService = sprintManagerService;
    }

    @Override
    public Project findProjectBySessionNoteId(long noteId) {
        this.checkReadExecutionPermission(noteId);
        Long projectId = this.sessionNoteDisplayDao.findProjectIdBySessionNoteId(noteId);
        if (projectId == null) {
            throw new UnknownEntityException(noteId, SessionNote.class);
        }
        return (Project)this.em.find(Project.class, (Object)projectId);
    }

    @Override
    public SessionNote findSessionNoteById(long noteId) {
        this.checkReadExecutionPermission(noteId);
        return (SessionNote)this.em.find(SessionNote.class, (Object)noteId);
    }

    private void checkReadExecutionPermission(long noteId) {
        Long executionId = this.sessionNoteDao.findExploratoryExecutionId(noteId);
        this.permissionService.checkPermission(Collections.singletonList(executionId), Permissions.READ.name(), Execution.class.getName());
    }

    @Override
    public RemoteIssueContext getRemoteIssueContext(long noteId, String squashPublicUrl, MessageSource messageSource) {
        SessionNote sessionNote = this.findSessionNoteById(noteId);
        return RemoteIssueContextHelper.getRemoteIssueContext(sessionNote, squashPublicUrl, messageSource);
    }

    @Override
    public BugTracker findBugTrackerByEntityId(long noteId) {
        return this.findSessionNoteById(noteId).getBugTracker();
    }

    @Override
    public void checkCanAddIssue(long noteId) {
        LOGGER.trace("Posting new issue for session note %d".formatted(noteId), new Object[0]);
        this.sessionNoteDao.findExploratoryExecutionId(noteId);
        if (SprintStatus.CLOSED.equals((Object)this.sprintManagerService.getSprintStatusByExecutionId(this.sessionNoteDao.findExploratoryExecutionId(noteId)))) {
            throw new SprintClosedException();
        }
    }

    @Override
    public IssueDetector fetchIssueDetector(long noteId) {
        return this.findSessionNoteById(noteId);
    }
}

