/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.AbstractGenericItem;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;

public class ItemXrayDto
extends AbstractGenericItem {
    private static final String PIVOT_ID_FORMAT = "%s_%s";
    private Long id;
    private String link;
    private String project;
    private String description;
    private String summary;
    private String type;
    private String priority;
    private String status;
    private String created;
    private String reporter;
    private String label;
    private String pivotId;
    private String parentId;
    private final List<CustomFieldXrayDto> customFields = new ArrayList<CustomFieldXrayDto>();
    private final List<String> associatedIssues = new ArrayList<String>();
    private final Map<String, String> associatedIssuesWithXrayKey = new HashMap<String, String>();
    private final List<String> testPlanPivotIds = new ArrayList<String>();
    private final List<String> labels = new ArrayList<String>();
    private boolean calledParameter;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPivotId() {
        return this.pivotId;
    }

    public void setPivotId(String pivotId) {
        this.pivotId = pivotId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<CustomFieldXrayDto> getCustomFields() {
        return this.customFields;
    }

    public List<String> getAssociatedIssues() {
        return this.associatedIssues;
    }

    public List<String> getTestPlanPivotIds() {
        return this.testPlanPivotIds;
    }

    public Map<String, String> getAssociatedIssuesWithXrayKey() {
        return this.associatedIssuesWithXrayKey;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean isCalledParameter() {
        return this.calledParameter;
    }

    public void setCalledParameter(boolean calledParameter) {
        this.calledParameter = calledParameter;
    }

    public void addPivotId(XrayField.Type type) {
        switch (type) {
            case STORY: {
                this.setPivotId(String.format(PIVOT_ID_FORMAT, "RQ", this.id));
                break;
            }
            case TEST: {
                this.setPivotId(String.format(PIVOT_ID_FORMAT, "TC", this.id));
                break;
            }
            case TEST_EXECUTION: 
            case SUB_TEST_EXECUTION: 
            case TEST_PLAN: {
                if (!this.isCampaign(type)) break;
                this.setPivotId(String.format(PIVOT_ID_FORMAT, "CP", this.id));
                break;
            }
        }
    }

    private boolean isCampaign(XrayField.Type type) {
        if (type == XrayField.Type.TEST_PLAN) {
            return true;
        }
        return this.getFilterCuf(XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN).map(CustomFieldXrayDto::getValue).allMatch(Objects::isNull);
    }

    public void setLabelFromLabels(List<String> labels) {
        this.label = StringUtils.join(labels, (char)',');
    }

    public List<CustomFieldXrayDto> getDataset() {
        return this.getFilterListCustomFieldXray(cuf -> Objects.nonNull(cuf.getDatasetRow())).toList();
    }

    public Map<Integer, Map<String, String>> getDatasetGherkin() {
        return this.getFilterListCustomFieldXray(cuf -> Objects.nonNull(cuf.getDatasetRow())).collect(Collectors.groupingBy(CustomFieldXrayDto::getDatasetRow, Collectors.toMap(CustomFieldXrayDto::getDatasetName, value -> {
            if (StringUtils.isNotBlank((CharSequence)value.getDatasetValue())) {
                return value.getDatasetValue();
            }
            return "null";
        }, (x, y) -> y, LinkedHashMap::new)));
    }

    public List<CustomFieldXrayDto> getStep() {
        return this.getFilterListCustomFieldXray(cuf -> Objects.nonNull(cuf.getStepIndex())).toList();
    }

    public List<CustomFieldXrayDto> getFilterCufs(XrayField.CustomFieldKey ... customFieldKey) {
        return this.getFilterCuf(customFieldKey).toList();
    }

    public List<String> getFilterCufValues(XrayField.CustomFieldKey ... customFieldKey) {
        return this.getFilterCuf(customFieldKey).map(CustomFieldXrayDto::getValue).toList();
    }

    public String getFilterCufValue(XrayField.CustomFieldKey ... customFieldKey) {
        return this.getFilterCuf(customFieldKey).map(CustomFieldXrayDto::getValue).findFirst().orElse(null);
    }

    public String getDateCufValue(String customFieldName, XrayField.CustomFieldKey ... customFieldKey) {
        return this.getFilterCuf(customFieldKey).filter(cuf -> customFieldName.equalsIgnoreCase(cuf.getName())).map(CustomFieldXrayDto::getValue).findFirst().orElse(null);
    }

    private Stream<CustomFieldXrayDto> getFilterCuf(XrayField.CustomFieldKey ... customFieldKey) {
        return this.getFilterListCustomFieldXray(cuf -> Arrays.stream(customFieldKey).anyMatch(cufKey -> cufKey.equals((Object)XrayField.CustomFieldKey.convertKey(cuf.getKey()))));
    }

    private Stream<CustomFieldXrayDto> getFilterListCustomFieldXray(Predicate<CustomFieldXrayDto> filterLambda) {
        return this.customFields.stream().filter(filterLambda);
    }
}

