/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.tf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.display.tf.AutomationTesterRequestDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.tf.AutomationRequestGrid;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional(readOnly=true)
public class AutomationTesterRequestDisplayServiceImpl
implements AutomationTesterRequestDisplayService {
    private final ProjectFinder projectFinder;
    private final DSLContext dslContext;

    public AutomationTesterRequestDisplayServiceImpl(ProjectFinder projectFinder, DSLContext dslContext) {
        this.projectFinder = projectFinder;
        this.dslContext = dslContext;
    }

    @Override
    public GridResponse findGlobalView(GridRequest request) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        AutomationRequestGrid grid = new AutomationRequestGrid(projectIds);
        return grid.getRows(request, this.dslContext);
    }

    @Override
    public GridResponse findReadyForTransmissionRequests(GridRequest request) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        GridFilterValue filterValue = new GridFilterValue();
        filterValue.setId("requestStatus");
        filterValue.setValues(Collections.singletonList(AutomationRequestStatus.READY_TO_TRANSMIT.name()));
        filterValue.setOperation(Operation.IN.name());
        request.getFilterValues().add(filterValue);
        AutomationRequestGrid grid = new AutomationRequestGrid(projectIds);
        return grid.getRows(request, this.dslContext);
    }

    @Override
    public GridResponse findToBeValidatedRequests(GridRequest request) {
        List<Long> projectIds = this.projectFinder.findAllReadableIds();
        GridFilterValue filterValue = new GridFilterValue();
        filterValue.setId("requestStatus");
        filterValue.setValues(this.getToBeValidatedAutomRequestStatuses());
        filterValue.setOperation(Operation.IN.name());
        request.getFilterValues().add(filterValue);
        AutomationRequestGrid grid = new AutomationRequestGrid(projectIds);
        return grid.getRows(request, this.dslContext);
    }

    private List<String> getToBeValidatedAutomRequestStatuses() {
        ArrayList<String> requestStatuses = new ArrayList<String>();
        requestStatuses.add(AutomationRequestStatus.WORK_IN_PROGRESS.name());
        requestStatuses.add(AutomationRequestStatus.REJECTED.name());
        requestStatuses.add(AutomationRequestStatus.SUSPENDED.name());
        return requestStatuses;
    }
}

