/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.testcase.QActionTestStep;
import org.squashtest.tm.domain.testcase.QCallTestStep;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.QTestStep;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class CallStepFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"TEST_CASE_CALLSTEPCOUNT"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        QTestCase outerTestCase = QTestCase.testCase;
        QTestCase initTestCase = new QTestCase("initTestCase");
        QTestStep testStep = new QTestStep("testStep");
        QActionTestStep actionTestStep = new QActionTestStep("actionTestStep");
        QCallTestStep callTestStep = new QCallTestStep("callTestStep");
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initTestCase)).leftJoin((CollectionExpression)initTestCase.steps, (Path)testStep)).leftJoin((EntityPath)actionTestStep)).on((Predicate)testStep.id.eq((Expression)actionTestStep.id))).leftJoin((EntityPath)callTestStep)).on((Predicate)testStep.id.eq((Expression)callTestStep.id))).where((Predicate)outerTestCase.id.eq((Expression)initTestCase.id))).groupBy((Expression)initTestCase.id);
        int min = Integer.parseInt(filter.getValues().get(0));
        switch (filter.getOperation()) {
            case "BETWEEN": {
                int max = Integer.parseInt(filter.getValues().get(1));
                subquery.having((Predicate)callTestStep.id.count().between((Number)min, (Number)max));
                break;
            }
            case "GREATER": {
                subquery.having((Predicate)callTestStep.id.count().gt((Number)min));
                break;
            }
            case "GREATER_EQUAL": {
                subquery.having((Predicate)callTestStep.id.count().goe((Number)min));
                break;
            }
            case "LOWER": {
                subquery.having((Predicate)callTestStep.id.count().lt((Number)min));
                break;
            }
            case "LOWER_EQUAL": {
                subquery.having((Predicate)callTestStep.id.count().loe((Number)min));
                break;
            }
            case "EQUALS": {
                subquery.having((Predicate)callTestStep.id.count().eq((Object)min));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation");
            }
        }
        query.where((Predicate)subquery.exists());
    }
}

