/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.tf;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomationRequest;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class AutomationRequestGrid
extends AbstractGrid {
    private final List<Long> projectIds;
    private final boolean assigneeIsNull;
    private final Long assigneeId;

    public AutomationRequestGrid(List<Long> projectIds) {
        this(projectIds, false, null);
    }

    public AutomationRequestGrid(List<Long> projectIds, boolean assigneeIsNull, Long assigneeId) {
        this.projectIds = projectIds;
        this.assigneeIsNull = assigneeIsNull;
        this.assigneeId = assigneeId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"PROJECT_ID")), new GridColumn(DSL.field((String)"TCLN_ID")), new GridColumn(DSL.field((String)"AUTOMATION_REQUEST_ID")), new GridColumn(DSL.field((String)"PROJECT_NAME")), new GridColumn(DSL.field((String)"NAME")), new GridColumn(DSL.field((String)"ASSIGNED_TO")), new GridColumn(DSL.field((String)"REFERENCE")), new GridColumn(DSL.field((String)"AUTOMATION_PRIORITY")), new LevelEnumColumn(AutomationRequestStatus.class, (Field<String>)DSL.field((String)"REQUEST_STATUS", String.class)), new GridColumn(DSL.field((String)"TRANSMITTED_ON", Timestamp.class)), new GridColumn(DSL.field((String)"ASSIGNED_ON")), new GridColumn(DSL.field((String)"SCRIPTED_TEST_CASE_ID")), new GridColumn(DSL.field((String)"KEYWORD_TEST_CASE_ID")), new GridColumn(DSL.field((String)"LOGIN")), new GridColumn(DSL.field((String)"AT_TECHNOLOGY_ID")), new GridColumn(DSL.field((String)"AUTOMATED_TEST_TECHNOLOGY")), new GridColumn(DSL.field((String)"SCM_REPOSITORY_ID")), new GridColumn(DSL.field((String)"AUTOMATED_TEST_REFERENCE")), new GridColumn(DSL.field((String)"CONFLICT_ASSOCIATION")), new GridColumn(DSL.field((String)"UUID")), new GridColumn(DSL.field((String)"AUTOMATED_TEST_FULL_NAME")), new GridColumn(DSL.field((String)"ASSIGNED_USER")), new GridColumn(DSL.field((String)"TC_MILESTONE_LOCKED")), new GridColumn(DSL.field((String)"KIND")), new GridColumn(DSL.field((String)"IS_MANUAL")), new GridColumn(DSL.field((String)"TA_SERVER_ID")), new GridColumn(DSL.field((String)"TEST_AUTOMATION_SERVER_KIND")), new GridColumn(DSL.field((String)"TEST_CASE_PATH")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<?> testCasePath = this.getTestCasePath();
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{Tables.PROJECT.PROJECT_ID.as("PROJECT_ID"), Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID"), AutomationRequest.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.as("AUTOMATION_REQUEST_ID"), Tables.PROJECT.NAME.as("PROJECT_NAME"), Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), AutomationRequest.AUTOMATION_REQUEST.ASSIGNED_TO.as("ASSIGNED_TO"), Tables.TEST_CASE.REFERENCE.as("REFERENCE"), AutomationRequest.AUTOMATION_REQUEST.AUTOMATION_PRIORITY.as("AUTOMATION_PRIORITY"), AutomationRequest.AUTOMATION_REQUEST.REQUEST_STATUS.as("REQUEST_STATUS"), AutomationRequest.AUTOMATION_REQUEST.TRANSMITTED_ON.as("TRANSMITTED_ON"), AutomationRequest.AUTOMATION_REQUEST.ASSIGNED_ON.as("ASSIGNED_ON"), Tables.SCRIPTED_TEST_CASE.TCLN_ID.as("SCRIPTED_TEST_CASE_ID"), Tables.KEYWORD_TEST_CASE.TCLN_ID.as("KEYWORD_TEST_CASE_ID"), Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY.as("LOGIN"), Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID.as("AT_TECHNOLOGY_ID"), Tables.AUTOMATED_TEST_TECHNOLOGY.NAME.as("AUTOMATED_TEST_TECHNOLOGY"), Tables.TEST_CASE.SCM_REPOSITORY_ID.as("SCM_REPOSITORY_ID"), Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.as("AUTOMATED_TEST_REFERENCE"), AutomationRequest.AUTOMATION_REQUEST.CONFLICT_ASSOCIATION.as("CONFLICT_ASSOCIATION"), Tables.TEST_CASE.UUID.as("UUID"), DSL.concat((Field[])new Field[]{DSL.inline((String)"/"), Tables.TEST_AUTOMATION_PROJECT.LABEL, DSL.inline((String)"/"), Tables.AUTOMATED_TEST.NAME}).as("AUTOMATED_TEST_FULL_NAME"), Tables.CORE_USER.LOGIN.as("ASSIGNED_USER"), this.countLockedMilestones().as("TC_MILESTONE_LOCKED"), DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)"GHERKIN").when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)"KEYWORD").otherwise((Object)"STANDARD").as("KIND"), AutomationRequest.AUTOMATION_REQUEST.IS_MANUAL.as("IS_MANUAL"), Tables.PROJECT.TA_SERVER_ID.as("TA_SERVER_ID"), Tables.TEST_AUTOMATION_SERVER.KIND.as("TEST_AUTOMATION_SERVER_KIND"), this.generateConcatenatedTestCasePath().as("TEST_CASE_PATH")}).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)AutomationRequest.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)AutomationRequest.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).on(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.eq((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID)).leftJoin((TableLike)Tables.CORE_USER).on(AutomationRequest.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Field)Tables.CORE_USER.PARTY_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST).on(Tables.TEST_CASE.TA_TEST.eq((Field)Tables.AUTOMATED_TEST.TEST_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_PROJECT).on(Tables.AUTOMATED_TEST.PROJECT_ID.eq((Field)Tables.TEST_AUTOMATION_PROJECT.TA_PROJECT_ID)).leftJoin(testCasePath).on(Tables.TEST_CASE.TCLN_ID.eq(testCasePath.field("TCLN_ID", Long.class))).where(this.whereCondition()).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, AutomationRequest.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID, Tables.TEST_AUTOMATION_PROJECT.TA_PROJECT_ID, Tables.CORE_USER.PARTY_ID, Tables.TEST_AUTOMATION_SERVER.SERVER_ID, Tables.AUTOMATED_TEST.TEST_ID}).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"TCLN_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    private Condition whereCondition() {
        Condition baseCondition = Tables.PROJECT.PROJECT_ID.in(this.projectIds).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NATIVE.name())).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()));
        if (this.assigneeIsNull) {
            baseCondition = baseCondition.and(AutomationRequest.AUTOMATION_REQUEST.ASSIGNED_TO.isNull());
        } else if (Objects.nonNull(this.assigneeId)) {
            baseCondition = baseCondition.and(AutomationRequest.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Object)this.assigneeId));
        }
        return baseCondition;
    }

    private SelectHavingStep<?> getTestCasePath() {
        TclnRelationshipClosure children = Tables.TCLN_RELATIONSHIP_CLOSURE.as("CHILDREN");
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as("TCLN_ID"), (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.as("DEPTH"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)children).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)children.ANCESTOR_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)children.DESCENDANT_ID)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.isNull()).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0));
    }

    private Field<String> generateConcatenatedTestCasePath() {
        SelectHavingStep<?> testCasePath = this.getTestCasePath();
        Field nodePath = DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.val((String)" / "), DSL.groupConcat((Field)testCasePath.field("NAME", String.class)).orderBy(new OrderField[]{testCasePath.field("DEPTH", Integer.class).desc()}).separator(" / ")});
        return DSL.when((Condition)DSL.count((Field)testCasePath.field("NAME", String.class)).ne((Object)0), (Field)nodePath).otherwise((Field)Tables.PROJECT.NAME);
    }

    private Field<Integer> countLockedMilestones() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name())).asField();
    }
}

