/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class GreaterConditionBuilder<T>
implements GridFilterConditionBuilder {
    private final Field<T> field;
    private final GridFilterValue gridFilterValue;
    private final boolean include;

    GreaterConditionBuilder(Field<T> field, GridFilterValue gridFilterValue, boolean include) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        List<String> values = gridFilterValue.getValues();
        if (values.isEmpty()) {
            throw new IllegalArgumentException("At least one value is required to build a greater condition");
        }
        this.field = field;
        this.gridFilterValue = gridFilterValue;
        this.include = include;
    }

    @Override
    public Condition build() {
        T value = GridFilterConditionBuilder.getGridFilterValueConvert(this.field, this.gridFilterValue.getValues().get(0));
        if (this.include) {
            return this.field.greaterOrEqual(value);
        }
        return this.field.greaterThan(value);
    }
}

