/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class TeamGrid
extends AbstractGrid {
    private static final String TEAM_ID = "TEAM_ID";

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.CORE_TEAM.PARTY_ID), new GridColumn((Field<?>)Tables.CORE_TEAM.NAME), new GridColumn((Field<?>)Tables.CORE_TEAM.DESCRIPTION), new GridColumn(DSL.isnull((Field)DSL.field((String)"TEAM_MEMBERS_COUNT", Integer.class), (Object)0).as("TEAM_MEMBERS_COUNT")), new GridColumn((Field<?>)Tables.CORE_TEAM.CREATED_ON), new GridColumn((Field<?>)Tables.CORE_TEAM.CREATED_BY), new GridColumn((Field<?>)Tables.CORE_TEAM.LAST_MODIFIED_ON), new GridColumn((Field<?>)Tables.CORE_TEAM.LAST_MODIFIED_BY));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, Integer>> teamMembersCount = this.getTeamMembersCount();
        return Tables.CORE_TEAM.leftJoin(teamMembersCount).on(teamMembersCount.field(TEAM_ID, Long.class).eq((Field)Tables.CORE_TEAM.PARTY_ID));
    }

    private SelectHavingStep<Record2<Long, Integer>> getTeamMembersCount() {
        return DSL.select((SelectField)Tables.CORE_TEAM_MEMBER.TEAM_ID.as(TEAM_ID), (SelectField)DSL.count((Field)Tables.CORE_TEAM_MEMBER.USER_ID).as("TEAM_MEMBERS_COUNT")).from((TableLike)Tables.CORE_TEAM).leftJoin((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM_MEMBER.TEAM_ID.eq((Field)Tables.CORE_TEAM.PARTY_ID)).groupBy(new GroupField[]{Tables.CORE_TEAM.PARTY_ID, Tables.CORE_TEAM_MEMBER.TEAM_ID});
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.CORE_TEAM.PARTY_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.upper((Field)Tables.CORE_TEAM.NAME).asc();
    }
}

