/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.denormalizedenvironment;

import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentTag;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.internal.repository.DenormalizedEnvironmentTagDao;

@Service(value="squashtest.tm.service.DenormalizedEnvironmentTagManagerService")
@Transactional
public class DenormalizedEnvironmentTagManagerServiceImpl
implements DenormalizedEnvironmentTagManagerService {
    private final DenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao;

    public DenormalizedEnvironmentTagManagerServiceImpl(DenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao) {
        this.denormalizedEnvironmentTagDao = denormalizedEnvironmentTagDao;
    }

    @Override
    public void createAllDenormalizedEnvironmentTagsForAutomatedExecution(List<String> environmentTags, Map<Long, AutomatedTestTechnology> extenderTechnologies) {
        ArrayList denormalizedEnvironmentTags = new ArrayList();
        extenderTechnologies.forEach((id, technology) -> {
            String testTechnologyPrefix;
            ArrayList tags = new ArrayList(environmentTags);
            String technologyKey = technology.getActionProviderKey();
            if (Objects.nonNull(technologyKey) && !technologyKey.isEmpty() && environmentTags.contains(testTechnologyPrefix = this.extractTechnologyPrefix(technologyKey))) {
                tags.remove(testTechnologyPrefix);
            }
            List<DenormalizedEnvironmentTag> extenderTags = tags.stream().map(tag -> new DenormalizedEnvironmentTag(id, DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER, tag)).toList();
            denormalizedEnvironmentTags.addAll(extenderTags);
        });
        this.denormalizedEnvironmentTagDao.saveAll(denormalizedEnvironmentTags);
    }

    private String extractTechnologyPrefix(String technologyKey) {
        return technologyKey.split("/")[0];
    }

    @Override
    public void removeDenormalizedTagsOnExecutionDelete(AutomatedExecutionExtender automatedExecutionExtender) {
        DenormalizedEnvironmentHolderType holderType = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER;
        List<DenormalizedEnvironmentTag> tags = this.denormalizedEnvironmentTagDao.findAllByHolderIdAndHolderType(automatedExecutionExtender.getId(), holderType);
        if (!tags.isEmpty()) {
            this.denormalizedEnvironmentTagDao.deleteAll(tags);
        }
    }
}

