/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Objects;
import org.squashtest.tm.domain.EntityType;

public class RequirementDeletionNode {
    private final Long id;
    private final RequirementDeletionNode parent;
    private boolean deletable = true;
    private final EntityType type;

    public RequirementDeletionNode(long id, RequirementDeletionNode parent, EntityType type) {
        this.id = id;
        this.parent = parent;
        this.type = type;
    }

    public RequirementDeletionNode(long id, EntityType type) {
        this.id = id;
        this.parent = null;
        this.type = type;
        this.deletable = false;
    }

    public void notDeletable() {
        this.deletable = false;
        if (this.shouldPropagateNonDeletable()) {
            this.parent.notDeletable();
        }
    }

    private boolean shouldPropagateNonDeletable() {
        return this.parent != null && this.parent.isFolder() && this.parent.isDeletable();
    }

    private boolean isFolder() {
        return EntityType.REQUIREMENT_FOLDER.equals((Object)this.type);
    }

    public Long getId() {
        return this.id;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public EntityType getType() {
        return this.type;
    }

    public boolean isOrphanRequirement() {
        if (this.deletable || !EntityType.REQUIREMENT.equals((Object)this.type)) {
            return false;
        }
        return this.parent != null && this.parent.isDeletable();
    }

    public RequirementDeletionNode findFirstNonDeletableAncestor() {
        if (!this.parent.isDeletable()) {
            return this.parent;
        }
        return this.parent.findFirstNonDeletableAncestor();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementDeletionNode that = (RequirementDeletionNode)obj;
        return Objects.equals(this.id, that.id) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public RequirementDeletionNode getParent() {
        return this.parent;
    }
}

