/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.squashtest.tm.domain.library.structures.LibraryTree;
import org.squashtest.tm.domain.library.structures.TreeNode;

public class LockedFolderInferenceTree
extends LibraryTree<Long, Node> {
    public void build(List<Long[]> pairedIds) {
        LinkedList<LibraryTree.TreeNodePair> allData = new LinkedList<LibraryTree.TreeNodePair>();
        for (Long[] pair : pairedIds) {
            Long parentKey = pair[0];
            Node childData = new Node(pair[1], true);
            allData.add(new LibraryTree.TreeNodePair((LibraryTree)this, (Object)parentKey, (TreeNode)childData));
        }
        this.addNodes(allData);
    }

    public void resolveLockedFolders() {
        this.doBottomUp(new Closure(){

            public void execute(Object input) {
                Node node = (Node)((Object)input);
                if (!node.isDeletable()) {
                    return;
                }
                boolean isDeletable = true;
                for (Node child : node.getChildren()) {
                    if (child.isDeletable()) continue;
                    isDeletable = false;
                    break;
                }
                node.setDeletable(isDeletable);
            }
        });
    }

    public void markLockedNodes(List<Long> nodeKeys) {
        LinkedList<Node> toUpdate = new LinkedList<Node>();
        for (Long key : nodeKeys) {
            toUpdate.add(new Node(key, false));
        }
        this.merge(toUpdate);
    }

    public List<Long> collectDeletableIds() {
        LinkedList<Long> deletableIds = new LinkedList<Long>();
        for (Node node : this.getAllNodes()) {
            if (!node.isDeletable()) continue;
            deletableIds.add((Long)node.getKey());
        }
        return deletableIds;
    }

    public static class Node
    extends TreeNode<Long, Node> {
        private boolean deletable = false;

        public Node() {
        }

        public Node(Long key) {
            super((Object)key);
        }

        public Node(Long key, boolean deletable) {
            super((Object)key);
            this.deletable = deletable;
        }

        public boolean isDeletable() {
            return this.deletable;
        }

        public void setDeletable(boolean isDeletable) {
            this.deletable = isDeletable;
        }

        protected Node self() {
            return this;
        }

        public void updateWith(Node newData) {
            this.deletable = newData.isDeletable();
        }
    }
}

