/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.service.campaign.export.CampaignExportWriter;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Service
public class CampaignExportWriterImpl
implements CampaignExportWriter {
    private static final char SEMI_COLUMN_SEPARATOR = ';';

    @Override
    public CSVPrinter getWriter(File file) throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setDelimiter(';').setQuoteMode(QuoteMode.ALL).get();
        return new CSVPrinter((Appendable)new FileWriter(file), csvFormat);
    }

    @Override
    public void write(CSVPrinter csvPrinter, Collection<String> values) {
        try {
            List<String> cleanedValues = values.stream().map(HTMLCleanupUtils::cleanHtml).toList();
            csvPrinter.printRecord(cleanedValues);
        }
        catch (IOException exception) {
            throw new ActionException("campaign export : I/O failure while writing the export file", (Throwable)exception);
        }
    }
}

