/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssueFinder;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.AutomatedExecutionExtenderKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignFolderKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionStepKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionUngroupedKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewUngroupedKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.FailureDetailKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.IterationKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.RequirementVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SessionNoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintReqVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestCaseKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestSuiteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.IssueHolderEntityType;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Service
@Transactional
public class RemoteKnownIssueFinderImpl
implements RemoteKnownIssueFinder {
    @Value(value="${squashtm.bugtracker.timeout:15}")
    private long timeout;
    private final BugTrackersService remoteBugTrackersService;
    private final CredentialsProvider credentialsProvider;
    private final BugTrackerDao bugTrackerDao;
    private final ExecutionKnownIssueFinder executionKnownIssueFinder;
    Map<String, LocalKnownIssueFinder> knownIssueFinderByEntityType;
    Map<String, LocalKnownIssueFinder> ungroupedKnownIssueFinderByEntityType;

    public RemoteKnownIssueFinderImpl(BugTrackersService remoteBugTrackersService, CredentialsProvider credentialsProvider, BugTrackerDao bugTrackerDao, TestCaseKnownIssueFinder testCaseKnownIssueFinder, RequirementVersionKnownIssueFinder requirementVersionKnownIssueFinder, IterationKnownIssueFinder iterationKnownIssueFinder, TestSuiteKnownIssueFinder testSuiteKnownIssueFinder, CampaignKnownIssueFinder campaignKnownIssueFinder, CampaignFolderKnownIssueFinder campaignFolderKnownIssueFinder, @Qualifier(value="executionKnownIssueFinder") ExecutionKnownIssueFinder executionKnownIssueFinder, AutomatedExecutionExtenderKnownIssueFinder automatedExecutionExtenderKnownIssueFinder, ExecutionStepKnownIssueFinder executionStepKnownIssueFinder, ExecutionUngroupedKnownIssueFinder executionUngroupedKnownIssueFinder, SessionNoteKnownIssueFinder sessionNoteKnownIssueFinder, @Qualifier(value="exploratorySessionOverviewKnownIssueFinder") ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder, ExploratorySessionOverviewUngroupedKnownIssueFinder exploratorySessionOverviewUngroupedKnownIssueFinder, SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder, SprintKnownIssueFinder sprintKnownIssueFinder, FailureDetailKnownIssueFinder failureDetailKnownIssueFinder) {
        this.remoteBugTrackersService = remoteBugTrackersService;
        this.credentialsProvider = credentialsProvider;
        this.bugTrackerDao = bugTrackerDao;
        this.executionKnownIssueFinder = executionKnownIssueFinder;
        this.knownIssueFinderByEntityType = Map.ofEntries(Map.entry(IssueHolderEntityType.CAMPAIGN_FOLDER.getValue(), campaignFolderKnownIssueFinder), Map.entry(IssueHolderEntityType.CAMPAIGN.getValue(), campaignKnownIssueFinder), Map.entry(IssueHolderEntityType.EXECUTION_STEP.getValue(), executionStepKnownIssueFinder), Map.entry(IssueHolderEntityType.EXECUTION.getValue(), executionKnownIssueFinder), Map.entry(IssueHolderEntityType.FAILURE_DETAIL.getValue(), failureDetailKnownIssueFinder), Map.entry(IssueHolderEntityType.ITERATION.getValue(), iterationKnownIssueFinder), Map.entry(IssueHolderEntityType.REQUIREMENT_VERSION.getValue(), requirementVersionKnownIssueFinder), Map.entry(IssueHolderEntityType.SESSION_NOTE.getValue(), sessionNoteKnownIssueFinder), Map.entry(IssueHolderEntityType.SESSION_OVERVIEW.getValue(), exploratorySessionOverviewKnownIssueFinder), Map.entry(IssueHolderEntityType.SPRINT_REQ_VERSION.getValue(), sprintReqVersionKnownIssueFinder), Map.entry(IssueHolderEntityType.SPRINT.getValue(), sprintKnownIssueFinder), Map.entry(IssueHolderEntityType.TEST_CASE.getValue(), testCaseKnownIssueFinder), Map.entry(IssueHolderEntityType.TEST_SUITE.getValue(), testSuiteKnownIssueFinder));
        this.ungroupedKnownIssueFinderByEntityType = Map.ofEntries(Map.entry(IssueHolderEntityType.EXECUTION_STEP.getValue(), executionStepKnownIssueFinder), Map.entry(IssueHolderEntityType.EXECUTION.getValue(), executionUngroupedKnownIssueFinder), Map.entry(IssueHolderEntityType.SESSION_NOTE.getValue(), sessionNoteKnownIssueFinder), Map.entry(IssueHolderEntityType.SESSION_OVERVIEW.getValue(), exploratorySessionOverviewUngroupedKnownIssueFinder), Map.entry(IssueHolderEntityType.FAILURE_DETAIL.getValue(), automatedExecutionExtenderKnownIssueFinder));
    }

    @Override
    public int getCountForExecution(Long executionId) {
        return this.executionKnownIssueFinder.countKnownIssues(executionId);
    }

    private List<RemoteKnownIssue> findRemoteKnownIssues(List<LocalKnownIssue> localKnownIssues, Sorting sorting) {
        Map<Long, Map<Long, List<LocalKnownIssue>>> map = this.getWorkMap(localKnownIssues);
        List<RemoteKnownIssue> remoteKnownIssues = this.collectRemoteIssues(map);
        this.applySorting(sorting, remoteKnownIssues);
        return remoteKnownIssues;
    }

    @Override
    public List<RemoteKnownIssue> findByEntityType(String entityType, long entityId, PagingAndSorting sorter) {
        List<LocalKnownIssue> localKnownIssues = this.knownIssueFinderByEntityType.get(entityType).getPaginatedKnownIssues(entityId, sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public List<RemoteKnownIssue> findAllByEntityType(String entityType, long entityId) {
        DefaultPagingAndSorting sorter = new DefaultPagingAndSorting("", true);
        List<LocalKnownIssue> localKnownIssues = this.ungroupedKnownIssueFinderByEntityType.get(entityType).getPaginatedKnownIssues(entityId, (PagingAndSorting)sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public int getCountByEntityType(String entityType, long entityId) {
        return this.knownIssueFinderByEntityType.get(entityType).countKnownIssues(entityId);
    }

    private void applySorting(Sorting sorting, List<RemoteKnownIssue> remoteKnownIssues) {
        remoteKnownIssues.sort(Comparator.comparing(remoteKnownIssue -> {
            String issueId = remoteKnownIssue.remoteIssue.getId();
            if ("azuredevops.bugtracker".equals(remoteKnownIssue.bugTracker.getKind())) {
                return this.extractSubstringAfterLastTilde(issueId);
            }
            return issueId;
        }));
        if (sorting.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
            Collections.reverse(remoteKnownIssues);
        }
    }

    private String extractSubstringAfterLastTilde(String remoteIssueId) {
        int lastIndex = remoteIssueId.lastIndexOf("~");
        return remoteIssueId.substring(lastIndex + 1);
    }

    private List<RemoteKnownIssue> collectRemoteIssues(Map<Long, Map<Long, List<LocalKnownIssue>>> map) {
        ArrayList<RemoteKnownIssue> remoteIssues = new ArrayList<RemoteKnownIssue>();
        map.forEach((projectId, issuesByBt) -> issuesByBt.forEach((btId, localIssues) -> {
            try {
                BugTracker bugTracker = (BugTracker)this.bugTrackerDao.getReferenceById(btId);
                Set<String> issueIds = localIssues.stream().map(local -> local.remoteIssueId).collect(Collectors.toSet());
                Future<List<RemoteIssue>> futureIssues = this.remoteBugTrackersService.getIssues((Long)projectId, (Collection<String>)issueIds, bugTracker, this.getCredentialsCache(), this.getLocaleContext(), this.getSecurityContext());
                List<RemoteIssue> btIssues = futureIssues.get(this.timeout, TimeUnit.SECONDS);
                List<RemoteKnownIssue> remoteKnownIssues = localIssues.stream().map(localIssue -> new RemoteKnownIssue(this.findRemoteIssue(btIssues, localIssue.remoteIssueId), bugTracker, (LocalKnownIssue)localIssue)).toList();
                remoteIssues.addAll(remoteKnownIssues);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new BugTrackerRemoteException((Throwable)ex);
            }
        }));
        return remoteIssues;
    }

    private RemoteIssue findRemoteIssue(List<RemoteIssue> btIssues, String remoteIssueId) {
        return btIssues.stream().filter(btIssue -> btIssue.getId().equals(remoteIssueId)).findAny().orElseThrow(() -> new RuntimeException("Error while collecting remote issues : cannot find remote issue with id " + remoteIssueId));
    }

    private Map<Long, Map<Long, List<LocalKnownIssue>>> getWorkMap(List<LocalKnownIssue> localKnownIssues) {
        HashMap<Long, Map<Long, List<LocalKnownIssue>>> map = new HashMap<Long, Map<Long, List<LocalKnownIssue>>>();
        localKnownIssues.forEach(issue -> {
            Long projectId = issue.projectId;
            if (!map.containsKey(projectId)) {
                map.put(projectId, new HashMap());
            }
            Long bugtrackerId = issue.bugtrackerId;
            if (!((Map)map.get(projectId)).containsKey(bugtrackerId)) {
                ((Map)map.get(projectId)).put(bugtrackerId, new ArrayList());
            }
            ((List)((Map)map.get(projectId)).get(bugtrackerId)).add(issue);
        });
        return map;
    }

    private LocaleContext getLocaleContext() {
        return LocaleContextHolder.getLocaleContext();
    }

    private SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    private UserCredentialsCache getCredentialsCache() {
        return this.credentialsProvider.getCache();
    }
}

