/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.bugtracker.CannotDeleteBugtrackerLinkedToSynchronisationException;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.BugtrackerProjectDao;
import org.squashtest.tm.service.internal.repository.IssueDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Transactional
@Service(value="squashtest.tm.service.BugTrackerManagerService")
public class BugTrackerManagerServiceImpl
implements BugTrackerManagerService {
    @Inject
    private BugTrackerDao bugTrackerDao;
    @Inject
    private BugTrackerModificationService bugTrackerModificationService;
    @Inject
    private IssueDao issueDao;
    @Inject
    private BugTrackersLocalService bugtrackersLocalService;
    @Inject
    private RequirementSyncExtenderDao syncreqDao;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private StoredCredentialsManager credentialsManager;
    @Inject
    private BugtrackerProjectDao bugtrackerProjectDao;
    @Inject
    private CustomGenericProjectManager customGenericProjectManager;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addBugTracker(BugTracker bugTracker) {
        String name = bugTracker.getName();
        BugTracker existing = this.bugTrackerDao.findByName(name);
        if (existing != null) {
            throw new NameAlreadyInUseException(NameAlreadyInUseException.EntityType.BUG_TRACKER, name);
        }
        this.bugTrackerDao.save(bugTracker);
        this.makeBugTrackerAuthProtocolConsistent(bugTracker);
    }

    private void makeBugTrackerAuthProtocolConsistent(BugTracker bugTracker) {
        List<AuthenticationProtocol> supportedProtocols = Arrays.asList(this.bugTrackerModificationService.getSupportedProtocols(bugTracker));
        if (!supportedProtocols.isEmpty() && !supportedProtocols.contains(bugTracker.getAuthenticationProtocol())) {
            bugTracker.setAuthenticationProtocol(supportedProtocols.get(0));
        }
    }

    @Override
    public Set<String> findBugTrackerKinds() {
        return this.bugtrackersLocalService.getProviderKinds();
    }

    @Override
    public List<BugTracker> findByKind(String kind) {
        return this.bugTrackerDao.findByKind(kind);
    }

    @Override
    public BugTracker findById(long bugTrackerId) {
        return (BugTracker)this.bugTrackerDao.getReferenceById(bugTrackerId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<BugTracker> findSortedBugtrackers(Pageable pageable) {
        return this.bugTrackerDao.findAll(pageable);
    }

    @Override
    public List<BugTracker> findDistinctBugTrackersForProjects(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.bugTrackerDao.findDistinctBugTrackersForProjects(projectIds);
    }

    @Override
    public List<BugTracker> findDistinctBugTrackersForProjectWithOtherJiraBt(List<Long> projectIds, List<String> jiraKinds) {
        return this.bugTrackerDao.findDistinctBugTrackersForProjectsWithJiraBt(projectIds, jiraKinds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteBugTrackers(List<Long> bugtrackerIds) {
        Map<Long, List<RemoteSynchronisation>> remoteSyncsByBugTrackerId = this.remoteSynchronisationDao.findByServers(bugtrackerIds).stream().collect(Collectors.groupingBy(remoteSynchronisation -> remoteSynchronisation.getServer().getId()));
        for (Map.Entry<Long, List<RemoteSynchronisation>> entry : remoteSyncsByBugTrackerId.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            BugTracker bugTracker = (BugTracker)this.bugTrackerDao.findById(entry.getKey()).orElseThrow();
            String synchronizationList = this.buildSynchronizationList(entry.getValue());
            throw new CannotDeleteBugtrackerLinkedToSynchronisationException(bugTracker.getId().longValue(), bugTracker.getName(), synchronizationList);
        }
        this.deleteIssuesLinkedToBugtrackers(bugtrackerIds);
        this.deleteLinkedSyncedRequirements(bugtrackerIds);
        this.deleteCredAndConfForBugTrackers(bugtrackerIds);
        this.unbindBugTrackersFromProjects(bugtrackerIds);
        this.doDeleteBugTrackers(bugtrackerIds);
    }

    private String buildSynchronizationList(List<RemoteSynchronisation> synchronizations) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>");
        synchronizations.forEach(sync -> {
            StringBuilder stringBuilder2 = stringBuilder.append(String.format("<li>%s - %s</li>", sync.getName(), sync.getProject().getName()));
        });
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private void deleteBugtrackersProjects(List<Long> bugTrackerIds) {
        this.bugtrackerProjectDao.deleteAllByBugTrackerIds(bugTrackerIds);
    }

    private void deleteIssuesLinkedToBugtrackers(List<Long> bugTrackerIds) {
        this.issueDao.deleteAllByBugTrackerIds(bugTrackerIds);
    }

    private void deleteLinkedSyncedRequirements(List<Long> bugTrackerIds) {
        this.syncreqDao.deleteAllByBugTrackerIds(bugTrackerIds);
    }

    private void deleteCredAndConfForBugTrackers(List<Long> bugTrackerIds) {
        bugTrackerIds.forEach(bugTrackerId -> {
            this.credentialsManager.deleteAppLevelCredentials((long)bugTrackerId);
            this.credentialsManager.deleteServerAuthConfiguration((long)bugTrackerId);
        });
        this.entityManager.flush();
    }

    private void unbindBugTrackersFromProjects(List<Long> bugTrackerIds) {
        this.deleteBugtrackersProjects(bugTrackerIds);
        this.customGenericProjectManager.unbindBugTrackers(bugTrackerIds);
    }

    private void doDeleteBugTrackers(List<Long> bugTrackerIds) {
        this.bugTrackerDao.deleteAllByIds(bugTrackerIds);
    }
}

