/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.testcase.TestCaseNature;
import org.squashtest.tm.domain.testcase.TestCaseType;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public final class InfoListItemCoercer<T extends InfoListItem>
extends AbstractTypeBasedCellValueCoercer<T>
implements CellValueCoercer<T> {
    private static final Set<String> OLD_NATURES = new HashSet<String>(8);
    private static final Set<String> OLD_TYPES;
    private ListRole role;

    static {
        TestCaseNature[] testCaseNatureArray = TestCaseNature.values();
        int n = testCaseNatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseNature nat = testCaseNatureArray[n2];
            OLD_NATURES.add(nat.toString());
            ++n2;
        }
        OLD_TYPES = new HashSet<String>(7);
        testCaseNatureArray = TestCaseType.values();
        n = testCaseNatureArray.length;
        n2 = 0;
        while (n2 < n) {
            TestCaseNature typ = testCaseNatureArray[n2];
            OLD_TYPES.add(typ.toString());
            ++n2;
        }
    }

    public InfoListItemCoercer(ListRole role) {
        this.role = role;
    }

    @Override
    protected T coerceStringCell(Cell cell) {
        String cellValue = cell.getStringCellValue();
        ListItemReference coerced = this.role == ListRole.ROLE_NATURE && OLD_NATURES.contains(cellValue) ? new ListItemReference("NAT_" + cellValue) : (this.role == ListRole.ROLE_TYPE && OLD_TYPES.contains(cellValue) ? new ListItemReference("TYP_" + cellValue) : new ListItemReference(cellValue));
        return (T)coerced;
    }

    @Override
    protected T coerceBlankCell(Cell cell) {
        return null;
    }

    public static enum ListRole {
        ROLE_NATURE,
        ROLE_TYPE,
        ROLE_CATEGORY;

    }
}

