/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.persistence.EntityManager;
import java.util.Collections;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.hibernate.EasyConstructorResultTransformer;

public final class ExportDaoUtils {
    private ExportDaoUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void setPathForCoverage(EntityManager em, PathService pathService, List<CoverageModel> coverageModels) {
        for (CoverageModel model : coverageModels) {
            model.setReqPath(ExportDaoUtils.getRequirementPath(em, model.getRequirementId(), model.getRequirementProjectName()));
            model.setTcPath(pathService.buildTestCasePath(model.getTcId()));
        }
    }

    public static String getRequirementPath(EntityManager em, Long requirementId, String requirementProjectName) {
        StringBuilder sb = new StringBuilder("\u001f");
        sb.append(requirementProjectName);
        sb.append("\u001f");
        String pathFromFolder = ExportDaoUtils.getPathFromFolder(em, requirementId);
        String pathFromParents = ExportDaoUtils.getPathFromParentsRequirements(em, requirementId);
        sb.append(pathFromFolder);
        sb.append(pathFromParents);
        return HibernatePathService.escapePath(sb.toString());
    }

    private static String getPathFromFolder(EntityManager em, Long requirementId) {
        String result = ExportDaoUtils.requirementVersionQuery(em, "requirement.findReqFolderPath", requirementId, "", String.class);
        return result.isEmpty() ? result : result + "\u001f";
    }

    private static String getPathFromParentsRequirements(EntityManager em, Long requirementId) {
        return ExportDaoUtils.requirementVersionQuery(em, "requirement.findReqParentPath", requirementId, "", String.class);
    }

    public static <R> R requirementVersionQuery(EntityManager em, String queryName, Long requirementId, R defaultValue, Class<R> resClass) {
        Session session = ExportDaoUtils.getStatelessSession(em);
        Query q = session.createNamedQuery(queryName, resClass);
        q.setParameter("requirementId", (Object)requirementId);
        Object result = q.uniqueResult();
        return (R)(result != null ? result : defaultValue);
    }

    public static <R> List<R> loadModels(EntityManager em, String queryName, List<Long> ids, String paramName, Class<R> resClass) {
        ids = !ids.isEmpty() ? ids : Collections.singletonList(-1L);
        Session session = ExportDaoUtils.getStatelessSession(em);
        Query q = session.createNamedQuery(queryName, resClass);
        q.setParameterList(paramName, ids, (BindableType)StandardBasicTypes.LONG);
        q.setTupleTransformer(new EasyConstructorResultTransformer<R>(resClass));
        return q.list();
    }

    public static Session getStatelessSession(EntityManager em) {
        Session s = (Session)em.unwrap(Session.class);
        s.setHibernateFlushMode(FlushMode.MANUAL);
        return s;
    }
}

