/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.importer;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.Target;

public class LogEntry
implements Comparable<LogEntry> {
    private Integer line;
    private Target target;
    private ImportMode mode;
    private ImportStatus status;
    private String i18nError;
    private String i18nImpact;
    private Object[] errorArgs;
    private Object[] impactArgs;

    public LogEntry(Target target, ImportStatus status, String i18nError) {
        this.target = target;
        this.status = status;
        this.i18nError = i18nError;
    }

    @Deprecated
    public LogEntry(Target target, ImportStatus status, String i18nError, Object[] errorArgs) {
        this(target, status, i18nError);
        this.setErrorArgsPrivately(errorArgs);
    }

    public static Builder failure() {
        return new Builder(ImportStatus.FAILURE);
    }

    public static Builder warning() {
        return new Builder(ImportStatus.WARNING);
    }

    public static Builder ok() {
        return new Builder(ImportStatus.OK);
    }

    public static Builder status(@NotNull ImportStatus status) {
        ImportStatus importStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)importStatus);
        return new Builder(status);
    }

    public Object[] getErrorArgs() {
        return this.errorArgs;
    }

    private void setErrorArgsPrivately(Object[] errorArgsParam) {
        this.errorArgs = errorArgsParam == null ? null : Arrays.copyOf(errorArgsParam, errorArgsParam.length);
    }

    public void setErrorArgs(Object ... errorArgs) {
        this.errorArgs = errorArgs;
    }

    public Object[] getImpactArgs() {
        return this.impactArgs;
    }

    public void setImpactArgs(Object ... impactArgs) {
        this.impactArgs = impactArgs;
    }

    @Override
    public int compareTo(LogEntry o) {
        if (!this.line.equals(o.line)) {
            return this.line - o.line;
        }
        if (this.status != o.getStatus()) {
            return this.status.getLevel() - o.getStatus().getLevel();
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntry logEntry = (LogEntry)o;
        if (!this.line.equals(logEntry.line)) {
            return false;
        }
        if (this.status != logEntry.status) {
            return false;
        }
        if (!this.i18nError.equals(logEntry.i18nError)) {
            return false;
        }
        return Arrays.deepEquals(this.errorArgs, logEntry.errorArgs);
    }

    public int hashCode() {
        int result = this.line.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (this.i18nError != null ? this.i18nError.hashCode() : 0);
        result = 31 * result + (this.errorArgs != null ? Arrays.hashCode(this.errorArgs) : 0);
        return result;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public void setMode(ImportMode mode) {
        this.mode = mode;
    }

    public Target getTarget() {
        return this.target;
    }

    public ImportStatus getStatus() {
        return this.status;
    }

    public String getI18nError() {
        return this.i18nError;
    }

    public String getI18nImpact() {
        return this.i18nImpact;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public static final class Builder {
        private final LogEntry product;

        private Builder(ImportStatus status) {
            this.product = new LogEntry(null, status, null);
        }

        public Builder forTarget(Target tgt) {
            this.product.target = tgt;
            return this;
        }

        public Builder atLine(int line) {
            this.product.line = line;
            return this;
        }

        public Builder withMessage(String key, Object ... args) {
            this.product.i18nError = key;
            this.product.errorArgs = args;
            return this;
        }

        public Builder withImpact(String key, Object ... args) {
            this.product.i18nImpact = key;
            this.product.impactArgs = args;
            return this;
        }

        public LogEntry build() {
            return this.product;
        }
    }
}

