/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.batchimport.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.batchimport.excel.ColumnMismatch;
import org.squashtest.tm.service.batchimport.excel.WorksheetMismatch;
import org.squashtest.tm.service.internal.batchimport.column.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.column.TemplateWorksheet;

public class WorksheetFormatStatus {
    private Map<ColumnMismatch, Set<TemplateColumn>> columnMismatches = new EnumMap<ColumnMismatch, Set<TemplateColumn>>(ColumnMismatch.class);
    private List<WorksheetMismatch> worksheetMismatches = new ArrayList<WorksheetMismatch>();
    private TemplateWorksheet worksheet;

    public WorksheetFormatStatus(TemplateWorksheet worksheet) {
        this.worksheet = worksheet;
    }

    public TemplateWorksheet getWorksheet() {
        return this.worksheet;
    }

    public void addMismatches(ColumnMismatch mismatchType, Collection<TemplateColumn> columnsMismatched) {
        if (!columnsMismatched.isEmpty()) {
            Set<TemplateColumn> columns = this.findOrAddColumnListForMismatch(mismatchType);
            columns.addAll(columnsMismatched);
            this.columnMismatches.put(mismatchType, columns);
        }
    }

    public boolean isFormatOk() {
        return this.columnMismatches.isEmpty() && this.worksheetMismatches.isEmpty();
    }

    public Map<ColumnMismatch, Set<String>> getColumnNamesByMismatches() {
        EnumMap<ColumnMismatch, Set<String>> result = new EnumMap<ColumnMismatch, Set<String>>(ColumnMismatch.class);
        for (Map.Entry<ColumnMismatch, Set<TemplateColumn>> mismatch : this.columnMismatches.entrySet()) {
            Set<String> columns = this.extractColumnFullNames(mismatch.getValue());
            HashSet<String> alreadyStoredColumns = (HashSet<String>)result.get((Object)mismatch.getKey());
            if (alreadyStoredColumns == null) {
                alreadyStoredColumns = new HashSet<String>();
            }
            alreadyStoredColumns.addAll(columns);
            result.put(mismatch.getKey(), alreadyStoredColumns);
        }
        return result;
    }

    private Set<String> extractColumnFullNames(Set<TemplateColumn> columns) {
        HashSet<String> columnNames = new HashSet<String>(columns.size());
        for (TemplateColumn column : columns) {
            columnNames.add(column.getFullName());
        }
        return columnNames;
    }

    public void addWorksheetMismatch(WorksheetMismatch worksheetMismatch) {
        this.worksheetMismatches.add(worksheetMismatch);
    }

    public void addMismatch(ColumnMismatch mismatchType, TemplateColumn colType) {
        Set<TemplateColumn> columns = this.findOrAddColumnListForMismatch(mismatchType);
        columns.add(colType);
        this.columnMismatches.put(mismatchType, columns);
    }

    private Set<TemplateColumn> findOrAddColumnListForMismatch(ColumnMismatch mismatchType) {
        Set<TemplateColumn> columns = this.columnMismatches.get((Object)mismatchType);
        if (columns == null) {
            columns = new HashSet<TemplateColumn>();
        }
        return columns;
    }
}

