/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.campaign;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.LevelComparator;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.statistics.CountOnEnum;

public class CampaignTestCaseSuccessRateStatistics {
    private final LinkedHashMap<TestCaseImportance, CountOnEnum<ExecutionStatus>> statistics = EnumSet.allOf(TestCaseImportance.class).stream().sorted(LevelComparator.getInstance()).collect(Collectors.toMap(Function.identity(), e -> new CountOnEnum<ExecutionStatus>(ExecutionStatus.class), (e1, e2) -> e1, LinkedHashMap::new));
    private final LinkedHashMap<TestCaseImportance, CountOnEnum<ExecutionStatus>> conclusivenessStats = EnumSet.allOf(TestCaseImportance.class).stream().sorted(LevelComparator.getInstance()).collect(Collectors.toMap(Function.identity(), e -> new CountOnEnum(ExecutionStatus.TERMINAL_STATUSES), (e1, e2) -> e1, LinkedHashMap::new));

    public void add(TestCaseImportance testCaseImportance, ExecutionStatus status, Long number) {
        this.statistics.get(testCaseImportance).add(status, number);
        this.conclusivenessStats.get(testCaseImportance).add(status, number);
    }

    public LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Conclusiveness, Integer>> getConclusiveness() {
        LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Conclusiveness, Integer>> output = new LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Conclusiveness, Integer>>();
        this.conclusivenessStats.forEach((testCaseImportance, executionStatusCountOnEnum) -> {
            LinkedHashMap<ExecutionStatus.Conclusiveness, Integer> linkedHashMap2 = output.put((TestCaseImportance)testCaseImportance, executionStatusCountOnEnum.getStatistics(ExecutionStatus.Conclusiveness::fromExecutionStatus, ExecutionStatus.Conclusiveness.class));
        });
        return output;
    }

    public LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Termination, Integer>> getTermination() {
        LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Termination, Integer>> output = new LinkedHashMap<TestCaseImportance, LinkedHashMap<ExecutionStatus.Termination, Integer>>();
        this.statistics.forEach((testCaseImportance, executionStatusCountOnEnum) -> {
            LinkedHashMap<ExecutionStatus.Termination, Integer> linkedHashMap2 = output.put((TestCaseImportance)testCaseImportance, executionStatusCountOnEnum.getStatistics(ExecutionStatus.Termination::fromExecutionStatus, ExecutionStatus.Termination.class));
        });
        return output;
    }

    public static CampaignTestCaseSuccessRateStatistics fromTuples(List<Object[]> tuples) {
        CampaignTestCaseSuccessRateStatistics result = new CampaignTestCaseSuccessRateStatistics();
        for (Object[] tuple : tuples) {
            result.add((TestCaseImportance)tuple[0], (ExecutionStatus)tuple[1], (Long)tuple[2]);
        }
        return result;
    }
}

