/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.spi;

import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueFindContext;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchTerm;
import org.squashtest.tm.bugtracker.advanceddomain.exception.InvalidRemoteIssueSearchRequestException;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.spi.BugtrackerConnectorBase;

public interface AdvancedBugTrackerConnector
extends BugtrackerConnectorBase {
    public URL makeViewIssueUrl(String var1);

    public AdvancedProject findProject(String var1) throws ProjectNotFoundException, BugTrackerRemoteException;

    public AdvancedProject findProjectById(String var1) throws ProjectNotFoundException, BugTrackerRemoteException;

    public AdvancedIssue createIssue(RemoteIssue var1) throws BugTrackerRemoteException;

    public RemoteIssue createReportIssueTemplate(String var1, RemoteIssueContext var2);

    public AdvancedIssue findIssue(String var1);

    public List<AdvancedIssue> findIssues(List<String> var1);

    default public List<AdvancedIssue> findKnownIssues(List<String> issueKeyList, RemoteIssueFindContext context) {
        return this.findIssues(issueKeyList);
    }

    default public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        return RemoteIssueSearchForm.defaultForm();
    }

    default public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest searchRequest) throws InvalidRemoteIssueSearchRequestException {
        String issueKey = ((RemoteIssueSearchTerm)searchRequest.getSearchTerms().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("You've reached the legacy fallback implementation for AdvancedBugTrackerConnector.searchIssue but you haven't provided any search terms."))).getStringValue();
        return Optional.ofNullable(this.findIssue(issueKey));
    }

    public void forwardAttachments(String var1, List<Attachment> var2);

    public Object executeDelegateCommand(DelegateCommand var1);

    default public void linkIssues(Long bugtrackerId, String remoteIssueKey, List<RemoteRequirementAndProjectId> remoteReqIds) {
        this.linkIssues(remoteIssueKey, remoteReqIds.stream().map(RemoteRequirementAndProjectId::remoteReqId).toList());
    }

    default public void linkIssues(String remoteIssueKey, List<String> remoteReqIds) {
    }
}

