/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.servers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.feature.FeatureManager;

public class UserCredentialsCache
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCredentialsCache.class);
    private final String user;
    private final Map<Long, Credentials> cache = new HashMap<Long, Credentials>();
    private final FeatureManager featureManager;

    public UserCredentialsCache(String user) {
        this(user, null);
    }

    public UserCredentialsCache(String user, FeatureManager featureManager) {
        if (user == null) {
            throw new NullArgumentException("UserCredentialsCache : username must not be null");
        }
        this.user = user;
        this.featureManager = featureManager;
    }

    public Credentials getCredentials(ThirdPartyServer server) {
        return this.cache.get(server.getId());
    }

    public void cacheIfAllowed(ThirdPartyServer server, Credentials credentials) {
        if (credentials == null) {
            throw new NullArgumentException("UserCredentialsCache : cannot set credentials if they are null. Perhaps you meant : discardCredentials(ThirdPartyServer) ?");
        }
        LOGGER.trace("UserCredentialsCache #{} : settings credentials of class '{}' for user '{}' (set credentials) ...", new Object[]{credentials.getClass(), this.toString(), this.user});
        if (this.isCachable(credentials)) {
            this.cache.put(server.getId(), credentials);
            LOGGER.trace("UserCredentialsCache #{} : credentials are allowed to stay in-memory and were stored.", new Object[0]);
        } else {
            LOGGER.trace("UserCredentialsCache #{} : credentials cannot reside in memory and were discarded.", new Object[0]);
        }
    }

    public void uncache(ThirdPartyServer server) {
        this.cache.remove(server.getId());
    }

    public boolean hasCredentials(ThirdPartyServer server) {
        return this.cache.get(server.getId()) != null;
    }

    public void absorb(UserCredentialsCache otherCache) {
        LOGGER.debug("UserCredentialsCache : merging credentials cache for user '{}'", new Object[]{this.user});
        if (!this.getUser().equals(otherCache.getUser())) {
            throw new IllegalArgumentException("attempted to merge ");
        }
        for (Map.Entry<Long, Credentials> anotherEntry : otherCache.cache.entrySet()) {
            Long id = anotherEntry.getKey();
            Credentials crds = anotherEntry.getValue();
            if (this.cache.containsKey(id) || crds == null) continue;
            LOGGER.trace("UserCredentialsCache : Trying to set credentials : UserCredentialsCache : {} . cache : {}", new Object[]{this.toString(), this.user});
            LOGGER.trace("UserCredentialsCache #{} : settings credentials for user '{}' (via merge)", new Object[]{this.toString(), this.user});
            this.cache.put(id, crds);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return String.format("[user : %s, credentials count : %d]", this.user, this.cache.size());
    }

    private boolean isCachable(Credentials credentials) {
        if (this.featureManager.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION)) {
            return BasicAuthenticationCredentials.class.isAssignableFrom(credentials.getClass());
        }
        return false;
    }
}

