/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.scripted.gherkin;

import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class ScriptedExecutionModelGenerator {
    public Model buildModel(GherkinDocument gherkinDocument) {
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return null;
        }
        Model model = new Model();
        model.scriptName = feature.getName();
        List scenarioDefinitions = feature.getChildren();
        if (scenarioDefinitions.isEmpty()) {
            return model;
        }
        ScenarioDefinition potentialBackground = (ScenarioDefinition)scenarioDefinitions.get(0);
        if (potentialBackground instanceof Background) {
            model.prerequisite = this.buildBackground((Background)potentialBackground);
        }
        for (ScenarioDefinition scenarioDefinition : scenarioDefinitions) {
            if (scenarioDefinition instanceof Scenario) {
                model.steps.add(this.buildScenarioStep(scenarioDefinition));
                continue;
            }
            if (!(scenarioDefinition instanceof ScenarioOutline)) continue;
            model.steps.addAll(this.buildScenarioOutlineSteps((ScenarioOutline)scenarioDefinition));
        }
        return model;
    }

    private ExecutionStep buildScenarioStep(ScenarioDefinition scenario) {
        ExecutionStep scenarioModel = new ExecutionStep();
        scenarioModel.name = scenario.getName();
        scenarioModel.keyword = scenario.getKeyword();
        scenarioModel.description = scenario.getDescription();
        scenarioModel.steps = scenario.getSteps().stream().map(this::buildStepLine).toList();
        return scenarioModel;
    }

    private List<ExecutionStep> buildScenarioOutlineSteps(ScenarioOutline scenario) {
        return scenario.getExamples().stream().flatMap(examples -> this.buildExamples((Examples)examples, scenario).stream()).toList();
    }

    private List<ExecutionStep> buildExamples(Examples examples, ScenarioOutline scenario) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        List<String> headers = this.getExampleHeaders(examples);
        int columns = headers.size();
        int rows = examples.getTableBody().size();
        int i = 0;
        while (i < rows) {
            ExecutionStep row = new ExecutionStep();
            row.name = scenario.getName();
            row.keyword = scenario.getKeyword();
            row.description = scenario.getDescription();
            List<String> valuesForThisLine = this.getExampleLineValue(examples, i);
            HashMap valueByHeader = new HashMap();
            IntStream.range(0, columns).forEach(j -> {
                String string = valueByHeader.put((String)headers.get(j), (String)valuesForThisLine.get(j));
            });
            row.steps = scenario.getSteps().stream().map(step -> this.appendStepLine((Step)step, valueByHeader)).toList();
            executionSteps.add(row);
            ++i;
        }
        return executionSteps;
    }

    private List<String> getExampleLineValue(Examples example, int i) {
        return ((TableRow)example.getTableBody().get(i)).getCells().stream().map(TableCell::getValue).toList();
    }

    private List<String> getExampleHeaders(Examples example) {
        return example.getTableHeader().getCells().stream().map(TableCell::getValue).toList();
    }

    private List<StepModel> buildBackground(Background background) {
        return background.getSteps().stream().map(this::buildStepLine).toList();
    }

    private StepModel buildStepLine(Step step) {
        StepModel stepModel = new StepModel();
        stepModel.keyword = step.getKeyword();
        stepModel.text = step.getText();
        stepModel.argument = this.extractArgument(step);
        return stepModel;
    }

    private StepModel appendStepLine(Step step, Map<String, String> valueByHeader) {
        StepModel stepModel = new StepModel();
        stepModel.keyword = step.getKeyword();
        stepModel.text = this.performParamSubstitution(valueByHeader, step.getText());
        stepModel.argument = this.extractArgument(step);
        return stepModel;
    }

    private ArgumentModel extractArgument(Step step) {
        Node argument = step.getArgument();
        if (argument == null) {
            return null;
        }
        ArgumentModel model = new ArgumentModel();
        if (argument instanceof DocString) {
            DocString docString = (DocString)argument;
            model.kind = ArgumentModel.Kind.DOCSTRING;
            model.value = docString.getContent();
            return model;
        }
        if (argument instanceof DataTable) {
            DataTable dataTable = (DataTable)argument;
            model.kind = ArgumentModel.Kind.DATATABLE;
            DataTableModel dataTableModel = new DataTableModel();
            ArrayList<List<String>> cells = new ArrayList<List<String>>();
            dataTableModel.cells = cells;
            model.dataTable = dataTableModel;
            for (TableRow tableRow : dataTable.getRows()) {
                ArrayList<String> row = new ArrayList<String>();
                cells.add(row);
                for (TableCell tableCell : tableRow.getCells()) {
                    row.add(tableCell.getValue());
                }
            }
        }
        return model;
    }

    private String performParamSubstitution(Map<String, String> valueByHeader, String text) {
        Pattern p = Pattern.compile("<[.*?[^>]]*>");
        Matcher m = p.matcher(text);
        while (m.find()) {
            String token = m.group();
            String header = token.substring(1, token.length() - 1);
            String value = valueByHeader.get(header);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = "<NO_DATA>";
            }
            text = text.replace(token, value);
        }
        return text;
    }

    public static class ArgumentModel {
        Kind kind;
        String value;
        DataTableModel dataTable;

        public Kind getKind() {
            return this.kind;
        }

        public String getValue() {
            return this.value;
        }

        public DataTableModel getDataTable() {
            return this.dataTable;
        }

        public static enum Kind {
            DOCSTRING,
            DATATABLE;

        }
    }

    public static class DataTableModel {
        List<List<String>> cells;

        public List<List<String>> getCells() {
            return this.cells;
        }
    }

    public static class ExecutionStep {
        String keyword;
        String name;
        String description;
        List<StepModel> steps;

        public String getKeyword() {
            return this.keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<StepModel> getSteps() {
            return this.steps;
        }

        public void setSteps(List<StepModel> steps) {
            this.steps = steps;
        }
    }

    public static class Model {
        String scriptName;
        List<StepModel> prerequisite;
        List<ExecutionStep> steps = new ArrayList<ExecutionStep>();

        public String getScriptName() {
            return this.scriptName;
        }

        public List<StepModel> getPrerequisite() {
            return this.prerequisite;
        }

        public List<ExecutionStep> getSteps() {
            return this.steps;
        }

        public boolean hasPrerequisite() {
            return this.prerequisite != null && !this.prerequisite.isEmpty();
        }
    }

    public static class StepModel {
        String keyword;
        String text;
        ArgumentModel argument;

        public String getKeyword() {
            return this.keyword;
        }

        public String getText() {
            return this.text;
        }

        public ArgumentModel getArgument() {
            return this.argument;
        }
    }
}

