/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.util.Strings;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.bdd.ActionWordText;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;

public final class TestCaseSectionBuilder {
    private static final char SPACE_CHAR = ' ';

    private TestCaseSectionBuilder() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated.");
    }

    public static String buildTestCasesSection(KeywordTestCase keywordTestCase) {
        List steps = keywordTestCase.getSteps();
        String testCaseName = keywordTestCase.getName();
        SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
        stringBuilder.appendLine("*** Test Cases ***").appendLine(testCaseName).append(SectionBuilderHelpers.formatDocumentationSettingLines(Collections.singletonList(testCaseName))).appendNewLine().append(TestCaseSectionBuilder.formatTestCaseParameterLines(keywordTestCase)).append(TestCaseSectionBuilder.buildStepsLines(steps)).appendNewLine();
        return stringBuilder.toString();
    }

    private static String formatTestCaseParameterLines(KeywordTestCase keywordTestCase) {
        List<List<String>> paramLines = TestCaseSectionBuilder.buildParamLines(keywordTestCase);
        if (!paramLines.isEmpty()) {
            TextGridFormatter gridFormatter = new TextGridFormatter();
            gridFormatter.addRows(paramLines);
            return gridFormatter.format(TextGridFormatter.withRowPrefix("    ")) + RobotSyntaxHelpers.NEW_LINE;
        }
        return "";
    }

    private static String buildStepsLines(List<TestStep> steps) {
        StringBuilder stepBuilder = new StringBuilder();
        int dataTableCounter = 1;
        int docStringCounter = 1;
        if (!steps.isEmpty()) {
            for (TestStep step : steps) {
                KeywordTestStep keywordStep = (KeywordTestStep)step;
                String stepScript = TestCaseSectionBuilder.writeBddStepScript(keywordStep, dataTableCounter, docStringCounter);
                if (!Strings.isBlank((String)keywordStep.getDatatable())) {
                    ++dataTableCounter;
                } else if (!Strings.isBlank((String)keywordStep.getDocstring())) {
                    ++docStringCounter;
                }
                stepBuilder.append("    ").append(stepScript).append('\n');
            }
            stepBuilder.append('\n');
        }
        return stepBuilder.toString();
    }

    public static String writeBddStepScript(KeywordTestStep testStep, int dataTableCounter, int docStringCounter) {
        ActionWord actionWord = testStep.getActionWord();
        List fragments = actionWord.getFragments();
        List parameterValues = testStep.getParamValues();
        String keywordScript = testStep.getKeyword().getLabel();
        String actionWordScript = TestCaseSectionBuilder.generateStepScriptFromActionWordFragments(fragments, parameterValues);
        String dataTable = testStep.getDatatable();
        String docString = testStep.getDocstring();
        String comment = testStep.getComment();
        StringBuilder stepBuilder = new StringBuilder().append(keywordScript).append(' ').append(actionWordScript);
        if (!Strings.isBlank((String)dataTable)) {
            stepBuilder.append(' ').append(ActionWordUtil.wrapWithDoubleQuotes((String)SectionBuilderHelpers.formatDatatableAccessor(dataTableCounter)));
        } else if (!Strings.isBlank((String)docString)) {
            stepBuilder.append(' ').append(ActionWordUtil.wrapWithDoubleQuotes((String)SectionBuilderHelpers.formatDocstringAccessor(docStringCounter)));
        }
        if (!Strings.isBlank((String)comment)) {
            String[] commentLines;
            String[] stringArray = commentLines = comment.split("\n");
            int n = commentLines.length;
            int n2 = 0;
            while (n2 < n) {
                String commentLine = stringArray[n2];
                stepBuilder.append('\n').append("    ").append('#').append(' ').append(commentLine);
                ++n2;
            }
        }
        return stepBuilder.toString();
    }

    private static String generateStepScriptFromActionWordFragments(List<ActionWordFragment> fragments, List<ActionWordParameterValue> parameterValues) {
        final StringBuilder stringBuilder = new StringBuilder();
        final Consumer<ActionWordParameter> consumer = parameter -> TestCaseSectionBuilder.appendParamValueToGenerateScript(parameter, parameterValues, stringBuilder);
        ActionWordFragmentVisitor visitor = new ActionWordFragmentVisitor(){

            public void visit(ActionWordText text) {
                stringBuilder.append(text.getUnescapedText());
            }

            public void visit(ActionWordParameter parameter) {
                consumer.accept(parameter);
            }
        };
        for (ActionWordFragment fragment : fragments) {
            fragment.accept(visitor);
        }
        return stringBuilder.toString();
    }

    private static void appendParamValueToGenerateScript(ActionWordParameter parameter, List<ActionWordParameterValue> parameterValues, StringBuilder stringBuilder) {
        Optional<ActionWordParameterValue> paramValue = parameterValues.stream().filter(pv -> pv.getActionWordParam() != null && pv.getActionWordParam().getId().equals(parameter.getId())).findAny();
        paramValue.ifPresent(actionWordParameterValue -> TestCaseSectionBuilder.updateBuilderWithParamValue(stringBuilder, actionWordParameterValue));
    }

    private static void updateBuilderWithParamValue(StringBuilder stringBuilder, ActionWordParameterValue actionWordParameterValue) {
        String paramValue = actionWordParameterValue.getValue();
        if ("\"\"".equals(paramValue)) {
            stringBuilder.append(paramValue);
        } else if (actionWordParameterValue.isLinkedToTestCaseParam()) {
            String replacedCharactersString = ActionWordUtil.substituteBracketsWithSquareBrackets((String)paramValue);
            replacedCharactersString = ActionWordUtil.removeEscapeCharacters((String)replacedCharactersString);
            String dictionaryAccess = RobotSyntaxHelpers.scalarVariable("dataset") + replacedCharactersString;
            stringBuilder.append(ActionWordUtil.wrapWithDoubleQuotes((String)dictionaryAccess));
        } else {
            String unescapedString = ActionWordUtil.removeEscapeCharacters((String)paramValue);
            stringBuilder.append(ActionWordUtil.wrapWithDoubleQuotes((String)unescapedString));
        }
    }

    private static List<List<String>> buildParamLines(KeywordTestCase keywordTestCase) {
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        if (SectionBuilderHelpers.isTestCaseUsingDatasets(keywordTestCase)) {
            lines.add(TestCaseSectionBuilder.buildCallToRetrieveKeyword("dataset", "Retrieve Dataset"));
        }
        if (SectionBuilderHelpers.isTestCaseUsingDatatables(keywordTestCase)) {
            lines.add(TestCaseSectionBuilder.buildCallToRetrieveKeyword("datatables", "Retrieve Datatables"));
        }
        if (SectionBuilderHelpers.isTestCaseUsingDocstrings(keywordTestCase)) {
            lines.add(TestCaseSectionBuilder.buildCallToRetrieveKeyword("docstrings", "Retrieve Docstrings"));
        }
        return lines;
    }

    private static List<String> buildCallToRetrieveKeyword(String assigneeName, String keywordName) {
        return Arrays.asList(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.dictionaryVariable(assigneeName)), keywordName);
    }
}

