/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestSuiteTestPlanGrid;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedSuitePreviewService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.user.UserAccountService;

@Service
public class AutomatedSuitePreviewServiceImpl
implements AutomatedSuitePreviewService {
    private final DSLContext dslContext;
    private final AutomatedSuiteDao autoSuiteDao;
    private final UserAccountService userAccountService;
    private final PermissionEvaluationService permissionService;
    private final IterationDisplayDao iterationDisplayDao;
    private final TestSuiteDisplayDao testSuiteDisplayDao;

    public AutomatedSuitePreviewServiceImpl(DSLContext dslContext, AutomatedSuiteDao autoSuiteDao, UserAccountService userAccountService, PermissionEvaluationService permissionService, IterationDisplayDao iterationDisplayDao, TestSuiteDisplayDao testSuiteDisplayDao) {
        this.dslContext = dslContext;
        this.autoSuiteDao = autoSuiteDao;
        this.userAccountService = userAccountService;
        this.permissionService = permissionService;
        this.iterationDisplayDao = iterationDisplayDao;
        this.testSuiteDisplayDao = testSuiteDisplayDao;
    }

    @Override
    public AutomatedSuitePreview preview(AutomatedSuiteCreationSpecification specification) {
        Long userId;
        List<Couple<TestAutomationProject, Long>> projects;
        boolean needManualServerSelection;
        specification.validate();
        this.checkPermission(specification);
        EntityReference contextEntity = specification.getContext();
        List<Long> testPlanSubset = specification.getTestPlanSubsetIds();
        if (!specification.getFilterValues().isEmpty() && testPlanSubset.isEmpty()) {
            GridRequest gridRequest = this.prepareNonPaginatedGridRequest(specification);
            Long contextId = contextEntity.getId();
            AbstractTestPlanGrid testPlanGrid = switch (contextEntity.getType()) {
                case EntityType.ITERATION -> {
                    Long testPlanId = this.iterationDisplayDao.findTestPlanId(contextId);
                    yield new IterationTestPlanGrid(testPlanId, null, this.iterationDisplayDao, this.permissionService);
                }
                case EntityType.TEST_SUITE -> new TestSuiteTestPlanGrid(contextId, null, this.testSuiteDisplayDao);
                default -> throw new IllegalArgumentException("Type " + String.valueOf(contextEntity.getType()) + " is not supported.");
            };
            GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
            specification.setTestPlanSubsetIds(this.extractIdsFromGridResponse(gridResponse));
        }
        if (!(needManualServerSelection = (projects = this.autoSuiteDao.findAllCalledByTestPlan(contextEntity, testPlanSubset, userId = this.getUserIfPermissionsOnIterationInsufficient(contextEntity))).stream().anyMatch(couple -> ((TestAutomationProject)couple.getA1()).getServer().isManualSlaveSelection()))) {
            needManualServerSelection = this.autoSuiteDao.itpiSelectionContainsSquashAutomTest(contextEntity, testPlanSubset);
        }
        Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> squashAutomServersMap = this.autoSuiteDao.findAllSquashAutomProjectPreviews(contextEntity, testPlanSubset, userId);
        this.sortTestCasesInAutomProjectPreview(squashAutomServersMap);
        squashAutomServersMap = this.filterOutProjectsWithNoTestCases(squashAutomServersMap);
        AutomatedSuitePreview preview = new AutomatedSuitePreview();
        preview.setSpecification(specification);
        List<AutomatedSuitePreview.TestAutomationProjectPreview> projectPreview = projects.stream().map(couple -> {
            TestAutomationProject taProject = (TestAutomationProject)couple.getA1();
            Long testCount = (Long)couple.getA2();
            return new AutomatedSuitePreview.TestAutomationProjectPreview((long)taProject.getId(), taProject.getLabel(), taProject.getServer().getName(), taProject.getSlaves(), (long)testCount);
        }).toList();
        preview.setManualServerSelection(needManualServerSelection);
        preview.setProjects(projectPreview);
        preview.setSquashAutomProjects(squashAutomServersMap.values());
        return preview;
    }

    private void sortTestCasesInAutomProjectPreview(Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> automProjectPreviewsMap) {
        for (AutomatedSuitePreview.SquashAutomProjectPreview automProjectPreview : automProjectPreviewsMap.values()) {
            automProjectPreview.getTestCases().sort(Comparator.comparing(AutomatedSuitePreview.TestCasePreviewInfo::getItemOrder, Comparator.nullsFirst(Comparator.naturalOrder())));
        }
    }

    private GridRequest prepareNonPaginatedGridRequest(AutomatedSuiteCreationSpecification specification) {
        GridRequest gridRequest = new GridRequest();
        gridRequest.setFilterValues(specification.getFilterValues());
        return gridRequest.toNonPaginatedRequest();
    }

    private List<Long> extractIdsFromGridResponse(GridResponse gridResponse) {
        return gridResponse.getDataRows().stream().map(DataRow::getId).map(Long::valueOf).toList();
    }

    private Long getUserIfPermissionsOnIterationInsufficient(EntityReference contextEntity) {
        Long userId = null;
        if (contextEntity.getType().equals((Object)EntityType.ITERATION) && !this.currentUserCanReadUnassigned(contextEntity.getId())) {
            userId = this.userAccountService.findCurrentUser().getId();
        }
        return userId;
    }

    private boolean currentUserCanReadUnassigned(Long iterationId) {
        return this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), iterationId, "org.squashtest.tm.domain.campaign.Iteration");
    }

    private Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> filterOutProjectsWithNoTestCases(Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> squashAutomServersMap) {
        return squashAutomServersMap.entrySet().stream().filter(longSquashAutomProjectPreviewEntry -> !((AutomatedSuitePreview.SquashAutomProjectPreview)longSquashAutomProjectPreviewEntry.getValue()).getTestCases().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void checkPermission(AutomatedSuiteCreationSpecification specification) {
        ArrayList<Long> singleId = new ArrayList<Long>();
        singleId.add(specification.getContext().getId());
        Class clazz = specification.getContext().getType() == EntityType.ITERATION ? Iteration.class : TestSuite.class;
        this.permissionService.checkPermission(singleId, Permissions.EXECUTE.name(), clazz.getName());
    }

    @Override
    public List<String> findTestListPreview(AutomatedSuiteCreationSpecification specification, long automatedProjectId) {
        specification.validate();
        this.checkPermission(specification);
        Long userId = this.getUserIfPermissionsOnIterationInsufficient(specification.getContext());
        return this.autoSuiteDao.findTestPathForAutomatedSuiteAndProject(specification.getContext(), specification.getTestPlanSubsetIds(), automatedProjectId, userId);
    }
}

