/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.servers;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.StoredCredentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.internal.servers.Crypto;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;

public class StoredContentHandlers {
    private static final String FIND_SERVER_AUTH_CONF = "StoredCredentials.findServerAuthConfByServerId";
    private static final String FIND_APP_LEVEL_CREDENTIALS = "StoredCredentials.findAppLevelCredentialsByServerId";
    private static final String FIND_USER_CREDENTIALS = "StoredCredentials.findUserCredentialsByServerId";
    private static final String FIND_PROJECT_CREDENTIALS = "StoredCredentials.findProjectCredentialsByServerId";
    private static final String FIND_REPORTING_CACHE_CREDENTIALS = "StoredCredentials.findReportingCacheCredentialsByServerId";
    private static final String PARAM_SERVER_ID = "serverId";
    private static final String PARAM_PROJECT_ID = "projectId";
    private static final String PARAM_USERNAME = "username";

    static abstract class AbstractCredentialsHandler
    implements StoredContentHandler<ManageableCredentials> {
        protected final long serverId;

        protected AbstractCredentialsHandler(long serverId) {
            this.serverId = serverId;
        }

        @Override
        public Class<ManageableCredentials> getDeserializationClass() {
            return ManageableCredentials.class;
        }

        @Override
        public StoredCredentials buildNewStoredCredentials(EntityManager em, Crypto.EncryptionOutcome encryptionOutcome) {
            StoredCredentials sc = new StoredCredentials();
            sc.setContentType(StoredCredentials.ContentType.CRED);
            sc.setAuthenticatedServer((ThirdPartyServer)em.find(ThirdPartyServer.class, (Object)this.serverId));
            sc.setEncryptedCredentials(encryptionOutcome.getEncryptedText());
            sc.setEncryptionVersion(encryptionOutcome.getVersion());
            return sc;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(StoredContentHandlers.PARAM_SERVER_ID, this.serverId).toString();
        }
    }

    public static class AppLevelHandler
    extends AbstractCredentialsHandler {
        protected AppLevelHandler(long serverId) {
            super(serverId);
        }

        @Override
        public Query getLocateQuery(EntityManager em) {
            return em.createNamedQuery(StoredContentHandlers.FIND_APP_LEVEL_CREDENTIALS).setParameter(StoredContentHandlers.PARAM_SERVER_ID, (Object)this.serverId);
        }
    }

    public static class AuthConfigurationHandler
    implements StoredContentHandler<ServerAuthConfiguration> {
        private final long serverId;

        public AuthConfigurationHandler(long serverId) {
            this.serverId = serverId;
        }

        @Override
        public Query getLocateQuery(EntityManager em) {
            return em.createNamedQuery(StoredContentHandlers.FIND_SERVER_AUTH_CONF).setParameter(StoredContentHandlers.PARAM_SERVER_ID, (Object)this.serverId);
        }

        @Override
        public Class<ServerAuthConfiguration> getDeserializationClass() {
            return ServerAuthConfiguration.class;
        }

        @Override
        public StoredCredentials buildNewStoredCredentials(EntityManager em, Crypto.EncryptionOutcome encryptionOutcome) {
            StoredCredentials sc = new StoredCredentials();
            sc.setContentType(StoredCredentials.ContentType.CONF);
            sc.setAuthenticatedServer((ThirdPartyServer)em.find(ThirdPartyServer.class, (Object)this.serverId));
            sc.setEncryptedCredentials(encryptionOutcome.getEncryptedText());
            sc.setEncryptionVersion(encryptionOutcome.getVersion());
            return sc;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(StoredContentHandlers.PARAM_SERVER_ID, this.serverId).toString();
        }
    }

    public static class ProjectHandler
    extends AppLevelHandler {
        private final long projectId;
        private final Supplier<GenericProject> projectSupplier;

        public ProjectHandler(long serverId, long projectId, Supplier<GenericProject> projectSupplier) {
            super(serverId);
            this.projectId = projectId;
            this.projectSupplier = projectSupplier;
        }

        @Override
        public Query getLocateQuery(EntityManager em) {
            return em.createNamedQuery(StoredContentHandlers.FIND_PROJECT_CREDENTIALS).setParameter(StoredContentHandlers.PARAM_SERVER_ID, (Object)this.serverId).setParameter(StoredContentHandlers.PARAM_PROJECT_ID, (Object)this.projectId);
        }

        @Override
        public StoredCredentials buildNewStoredCredentials(EntityManager em, Crypto.EncryptionOutcome encryptionOutcome) {
            StoredCredentials sc = super.buildNewStoredCredentials(em, encryptionOutcome);
            sc.setProject(this.projectSupplier.get());
            return sc;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append(StoredContentHandlers.PARAM_SERVER_ID, this.serverId).append(StoredContentHandlers.PARAM_PROJECT_ID, this.projectId).toString();
        }
    }

    public static class ReportingCacheHandler
    extends AbstractCredentialsHandler {
        protected ReportingCacheHandler(long serverId) {
            super(serverId);
        }

        @Override
        public Query getLocateQuery(EntityManager em) {
            return em.createNamedQuery(StoredContentHandlers.FIND_REPORTING_CACHE_CREDENTIALS).setParameter(StoredContentHandlers.PARAM_SERVER_ID, (Object)this.serverId);
        }

        @Override
        public StoredCredentials buildNewStoredCredentials(EntityManager em, Crypto.EncryptionOutcome encryptionOutcome) {
            StoredCredentials sc = super.buildNewStoredCredentials(em, encryptionOutcome);
            sc.setReportingCacheCredentials(true);
            return sc;
        }
    }

    static interface StoredContentHandler<T> {
        public Query getLocateQuery(EntityManager var1);

        public Class<T> getDeserializationClass();

        public StoredCredentials buildNewStoredCredentials(EntityManager var1, Crypto.EncryptionOutcome var2);
    }

    public static class UserCredentialsHandler
    extends AppLevelHandler {
        public final String username;
        private final Supplier<User> userSupplier;

        UserCredentialsHandler(long serverId, String username, Supplier<User> userSupplier) {
            super(serverId);
            this.username = username;
            this.userSupplier = userSupplier;
        }

        @Override
        public Query getLocateQuery(EntityManager em) {
            return em.createNamedQuery(StoredContentHandlers.FIND_USER_CREDENTIALS).setParameter(StoredContentHandlers.PARAM_SERVER_ID, (Object)this.serverId).setParameter(StoredContentHandlers.PARAM_USERNAME, (Object)this.username);
        }

        @Override
        public StoredCredentials buildNewStoredCredentials(EntityManager em, Crypto.EncryptionOutcome encryptionOutcome) {
            StoredCredentials sc = super.buildNewStoredCredentials(em, encryptionOutcome);
            sc.setAuthenticatedUser(this.userSupplier.get());
            return sc;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append(StoredContentHandlers.PARAM_SERVER_ID, this.serverId).append(StoredContentHandlers.PARAM_USERNAME, (Object)this.username).toString();
        }
    }
}

