/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.servers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class Crypto {
    public static final int VERSION = 1;
    private static final String KEY_GEN = "PBKDF2WithHmacSHA1";
    private static final String KEY_ALG = "AES";
    private static final String CRYPT_ALG = "AES/CBC/PKCS5Padding";
    private static final int SALT_SIZE = 8;
    private static final int ITER_CNT = 65556;
    private static final int KEY_LEN = 128;
    private static final String CHARSET = "UTF-8";
    private char[] keyPassword;

    public Crypto(char[] keyPassword) {
        this.keyPassword = (char[])(keyPassword == null ? null : Arrays.copyOf(keyPassword, keyPassword.length));
    }

    public int getVersion() {
        return 1;
    }

    EncryptionOutcome encrypt(String toEncrypt) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] salt = this.generateSalt();
        SecretKeySpec keySpec = this.generateKeySpec(this.keyPassword, salt);
        Cipher cipher = this.createEncryptionCipher(keySpec);
        byte[] iv = this.getIV(cipher);
        byte[] encrypted = this.doEncrypt(cipher, toEncrypt);
        byte[] finalBytes = this.appendEverything(salt, iv, encrypted);
        String encoded = Base64.getEncoder().encodeToString(finalBytes);
        return new EncryptionOutcome(encoded, 1);
    }

    String decrypt(String encrypted) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = this.createPlainCipher();
        EncryptionBytes encBytes = this.chunkEncryption(cipher, encrypted);
        SecretKeySpec keySpec = this.generateKeySpec(this.keyPassword, encBytes.getSalt());
        this.initCipher(cipher, keySpec, encBytes.getIv());
        byte[] decrypted = this.doDecrypt(cipher, encBytes.getEncryptedBytes());
        return this.decryptedToString(decrypted);
    }

    void dispose() {
        Arrays.fill(this.keyPassword, '\u0000');
    }

    private SecretKeySpec generateKeySpec(char[] pwd, byte[] salt) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(pwd, salt, 65556, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_GEN);
        SecretKey secKey = keyFactory.generateSecret(keySpec);
        return new SecretKeySpec(secKey.getEncoded(), KEY_ALG);
    }

    private Cipher createPlainCipher() throws GeneralSecurityException {
        return Cipher.getInstance(CRYPT_ALG);
    }

    private byte[] generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return salt;
    }

    private Cipher createEncryptionCipher(SecretKeySpec keySpec) throws GeneralSecurityException {
        Cipher cipher = null;
        cipher = Cipher.getInstance(CRYPT_ALG);
        cipher.init(1, keySpec);
        return cipher;
    }

    private final byte[] getIV(Cipher cipher) throws GeneralSecurityException {
        AlgorithmParameters params = cipher.getParameters();
        return params.getParameterSpec(IvParameterSpec.class).getIV();
    }

    private byte[] doEncrypt(Cipher cipher, String text) throws UnsupportedEncodingException, GeneralSecurityException {
        return cipher.doFinal(text.getBytes(CHARSET));
    }

    private byte[] appendEverything(byte[] salt, byte[] iv, byte[] encrypted) {
        byte[] finalBytes = new byte[salt.length + iv.length + encrypted.length];
        ByteBuffer buffer = ByteBuffer.wrap(finalBytes);
        buffer.put(salt);
        buffer.put(iv);
        buffer.put(encrypted);
        return finalBytes;
    }

    private EncryptionBytes chunkEncryption(Cipher cipher, String base64Encrypted) {
        byte[] allBytes = Base64.getDecoder().decode(base64Encrypted);
        ByteBuffer buffer = ByteBuffer.wrap(allBytes);
        byte[] salt = new byte[8];
        byte[] iv = new byte[cipher.getBlockSize()];
        byte[] encrypted = new byte[buffer.capacity() - salt.length - iv.length];
        buffer.get(salt, 0, salt.length);
        buffer.get(iv, 0, iv.length);
        buffer.get(encrypted);
        return new EncryptionBytes(salt, iv, encrypted);
    }

    private void initCipher(Cipher cipher, SecretKeySpec key, byte[] iv) throws GeneralSecurityException {
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
    }

    private byte[] doDecrypt(Cipher cipher, byte[] encrypted) throws GeneralSecurityException {
        return cipher.doFinal(encrypted);
    }

    private String decryptedToString(byte[] decrypted) throws UnsupportedEncodingException {
        return new String(decrypted, CHARSET);
    }

    static final class EncryptionBytes {
        private byte[] salt;
        private byte[] iv;
        private byte[] encryptedBytes;

        EncryptionBytes(byte[] salt, byte[] iv, byte[] encryptedBytes) {
            this.salt = this.copyArrayOrReturnNull(salt);
            this.iv = this.copyArrayOrReturnNull(iv);
            this.encryptedBytes = this.copyArrayOrReturnNull(encryptedBytes);
        }

        private byte[] copyArrayOrReturnNull(byte[] arrayToCopy) {
            if (arrayToCopy == null) {
                return new byte[0];
            }
            return Arrays.copyOf(arrayToCopy, arrayToCopy.length);
        }

        byte[] getSalt() {
            return this.salt;
        }

        byte[] getIv() {
            return this.iv;
        }

        byte[] getEncryptedBytes() {
            return this.encryptedBytes;
        }
    }

    static final class EncryptionOutcome {
        private String encryptedText;
        private int version;

        EncryptionOutcome(String encryptedText, int version) {
            this.encryptedText = encryptedText;
            this.version = version;
        }

        String getEncryptedText() {
            return this.encryptedText;
        }

        int getVersion() {
            return this.version;
        }
    }
}

