/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.jooq.domain.tables.Sprint;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class HibernateSprintDao
extends HibernateEntityDao<org.squashtest.tm.domain.campaign.Sprint>
implements SprintDao {
    private static final String SPRINT_GROUP_IDS = "sprintGroupIds";
    private final DSLContext dslContext;

    public HibernateSprintDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<org.squashtest.tm.domain.campaign.Sprint> findByRemoteSynchronisationIdAndRemoteSprintIds(Long remoteSynchronisationId, List<Long> remoteSprintIds) {
        return this.entityManager.createNamedQuery("Sprint.findByRemoteSynchronisationIdAndRemoteSprintIds", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("remoteSynchronisationId", (Object)remoteSynchronisationId).setParameter("remoteSprintIds", remoteSprintIds).getResultList();
    }

    @Override
    public List<Long> findSquashSprintIdsHavingDeletedRemoteSprint(Long remoteSynchronisationId, List<Long> existingRemoteSprintIds) {
        return this.dslContext.select((SelectField)Sprint.SPRINT.CLN_ID.as("ID")).from((TableLike)Sprint.SPRINT).where(Sprint.SPRINT.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).and(Sprint.SPRINT.REMOTE_SPRINT_ID.notIn(existingRemoteSprintIds)).fetchInto(Long.class);
    }

    @Override
    public void deleteRemoteSynchronisationFromSprint(List<Long> remoteSyncIds) {
        this.entityManager.createNamedQuery("Sprint.deleteRemoteSynchronisationFromSprint").setParameter("remoteSyncIds", remoteSyncIds).executeUpdate();
    }

    @Override
    public void deleteRemoteSynchronisationFromSprintId(long sprintId) {
        this.entityManager.createNamedQuery("Sprint.deleteRemoteSynchronisationFromSprintId").setParameter("sprintId", (Object)sprintId).executeUpdate();
    }

    @Override
    @UsedInPlugin(names={PluginName.XSQUASH4JIRA, PluginName.XSQUASH4GITLAB})
    public void updateRemoteStateOfSynchronisedSprintsByIds(List<Long> sprintIds, String status) {
        this.entityManager.createNamedQuery("Sprint.updateRemoteStateOfSynchronisedSprintsByIds").setParameter("status", (Object)status).setParameter("sprintIds", sprintIds).executeUpdate();
    }

    @Override
    public List<org.squashtest.tm.domain.campaign.Sprint> loadNodeForPaste(Collection<Long> ids) {
        List sprints = this.entityManager.createQuery(" SELECT distinct s FROM Sprint s left join fetch s.project p left join fetch s.attachmentList al left join fetch al.attachments a left join fetch a.content c WHERE s.id IN (:ids)", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("ids", ids).getResultList();
        new EntityGraphQueryBuilder<org.squashtest.tm.domain.campaign.Sprint>(this.entityManager, org.squashtest.tm.domain.campaign.Sprint.class, "SELECT distinct s FROM Sprint s join fetch s.sprintReqVersions srv where s in :sprints").executeDistinctList(Map.of("sprints", sprints));
        this.entityManager.createQuery("select distinct tp from Sprint s join s.sprintReqVersions srv join srv.testPlan tp left join fetch tp.testPlanItems tpi left join fetch tpi.exploratorySessionOverview eso left join fetch eso.attachmentList al left join fetch al.attachments a left join fetch a.content c where s in :sprints", TestPlan.class).setParameter("sprints", (Object)sprints).getResultList();
        return sprints;
    }

    @Override
    public org.squashtest.tm.domain.campaign.Sprint loadForExecutionResume(long sprintId) {
        org.squashtest.tm.domain.campaign.Sprint sprint = (org.squashtest.tm.domain.campaign.Sprint)this.entityManager.createQuery("select distinct s\nfrom Sprint s\njoin fetch s.attachmentList list\nleft join fetch list.attachments\nwhere s.id = :id", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("id", (Object)sprintId).getSingleResult();
        this.entityManager.createQuery("select distinct s\nfrom Sprint s\nleft join fetch s.sprintReqVersions srv\nwhere s.id = :id", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("id", (Object)sprintId).getSingleResult();
        List<Long> sprintReqVersionsIds = sprint.getSprintReqVersions().stream().map(SprintReqVersion::getId).toList();
        this.entityManager.createQuery("select distinct srv\nfrom SprintReqVersion srv\njoin fetch srv.testPlan tp\nleft join fetch tp.testPlanItems\nwhere srv.id in :ids", SprintReqVersion.class).setParameter("ids", sprintReqVersionsIds).getResultList();
        List<Long> itemIds = sprint.getSprintReqVersions().stream().flatMap(srv -> srv.getTestPlan().getTestPlanItems().stream()).map(TestPlanItem::getId).toList();
        if (!itemIds.isEmpty()) {
            this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.referencedTestCase tc\nleft join fetch tc.steps\nwhere tpi.id in :ids", TestPlanItem.class).setParameter("ids", itemIds).getResultList();
            this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.executions exec\nwhere tpi.id in :ids", TestPlanItem.class).setParameter("ids", itemIds).getResultList();
            this.entityManager.createQuery("select distinct exec\nfrom Execution exec\nleft join fetch exec.steps\nleft join fetch exec.automatedExecutionExtender\nwhere exec.testPlanItem.id in :ids", Execution.class).setParameter("ids", itemIds).getResultList();
        }
        return sprint;
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long sprintId) {
        return (Boolean)this.entityManager.createQuery("select count(s) > 0\nfrom Sprint s\njoin s.sprintReqVersions srv\njoin srv.testPlan tp\njoin tp.testPlanItems item\nwhere s.id = :id and item.referencedTestCase is null", Boolean.class).setParameter("id", (Object)sprintId).getSingleResult();
    }

    @Override
    public List<Long> findAllSprintIdsBySprintGroupIds(List<Long> sprintGroupIds) {
        if (sprintGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("Sprint.findAllSprintIdsBySprintGroupIds", Long.class);
        query.setParameter(SPRINT_GROUP_IDS, sprintGroupIds);
        return query.getResultList();
    }

    @Override
    public List<Long> getTestPlanItemIdsAssignedToUser(long testPlanOwnerId, String testerLogin) {
        return this.entityManager.createQuery("select tpi.id\nfrom Sprint s\njoin s.sprintReqVersions srv\njoin srv.testPlan.testPlanItems tpi\njoin tpi.assignee assignee\nwhere s.id = :id and assignee.login = :login", Long.class).setParameter("id", (Object)testPlanOwnerId).setParameter("login", (Object)testerLogin).getResultList();
    }

    @Override
    public List<Long> getTestPlanItemIds(long testPlanOwnerId) {
        return this.entityManager.createQuery("select tpi.id\nfrom Sprint s\njoin s.sprintReqVersions srv\njoin srv.testPlan.testPlanItems tpi\nwhere s.id = :id", Long.class).setParameter("id", (Object)testPlanOwnerId).getResultList();
    }
}

