/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.repository.GenericDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

public abstract class HibernateDao<ENTITY_TYPE>
implements GenericDao<ENTITY_TYPE> {
    private static final String UNCHECKED = "unchecked";
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateDao.class);
    protected final Class<ENTITY_TYPE> entityType;
    @PersistenceContext
    protected EntityManager entityManager;

    protected HibernateDao() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityType = (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public void persist(List<ENTITY_TYPE> transientEntities) {
        for (ENTITY_TYPE transientEntity : transientEntities) {
            this.persist(transientEntity);
        }
    }

    @Override
    public void persist(ENTITY_TYPE transientEntity) {
        this.persistEntity(transientEntity);
    }

    @Override
    public void remove(ENTITY_TYPE entity) {
        this.removeEntity(entity);
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    protected ENTITY_TYPE getEntity(long objectId) {
        return (ENTITY_TYPE)this.entityManager.find(this.entityType, (Object)objectId);
    }

    protected void persistEntity(Object entity) {
        this.entityManager.persist(entity);
    }

    protected <R> List<R> executeListNamedQuery(String queryName, SetQueryParametersCallback setParams) {
        Query q = this.entityManager.createNamedQuery(queryName);
        setParams.setQueryParameters(q);
        return q.getResultList();
    }

    protected <R> R executeEntityNamedQuery(String queryName, String paramName, Object paramValue) {
        return (R)this.entityManager.createNamedQuery(queryName).setParameter(paramName, paramValue).getSingleResult();
    }

    protected <R> R executeEntityNamedQuery(String queryName, SetQueryParametersCallback setParams) {
        Query q = this.entityManager.createNamedQuery(queryName);
        setParams.setQueryParameters(q);
        try {
            return (R)q.getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.debug("No result for query {}", new Object[]{queryName, e});
            return null;
        }
    }

    protected <R> R executeEntityNamedQuery(String queryName) {
        return (R)this.entityManager.createNamedQuery(queryName).getSingleResult();
    }

    protected void removeEntity(ENTITY_TYPE entity) {
        this.entityManager.remove(entity);
    }

    @Override
    public void removeAll(List<ENTITY_TYPE> entities) {
        for (ENTITY_TYPE entity : entities) {
            this.removeEntity(entity);
        }
    }
}

