/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomRemoteSynchronisationDao;

@Repository(value="squashtest.tm.repository.RemoteSynchronisationDao")
@Primary
public class CustomRemoteSynchronisationDaoImpl
implements CustomRemoteSynchronisationDao {
    @Inject
    private DSLContext dslContext;

    @Override
    public List<String> findAllRemoteSynchronisationOptionsFromProjectName(String projectName) {
        String xsquash4GitLab = SynchronisationKind.XSQUASH4GITLAB.getName();
        String xsquash4Jira = SynchronisationKind.XSQUASH4JIRA.getName();
        return this.dslContext.select((SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_OPTIONS).from((TableLike)Tables.REMOTE_SYNCHRONISATION).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.PROJECT_ID)).where(Tables.PROJECT.NAME.eq((Object)projectName)).and(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)xsquash4GitLab).or(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)xsquash4Jira))).fetchInto(String.class);
    }

    @Override
    public List<String> findAllReqSyncExtenderKeys(Long remoteSyncId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)).orderBy((OrderField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).fetch((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, String.class);
    }

    @Override
    public List<Long> findActiveRemoteSyncIdsByPluginId(String pluginId) {
        return this.dslContext.select((SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID).from((TableLike)Tables.REMOTE_SYNCHRONISATION).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)pluginId)).and(Tables.REMOTE_SYNCHRONISATION.SYNC_ENABLE.isTrue()).orderBy((OrderField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.desc()).fetch((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID, Long.class);
    }

    @Override
    public Map<Long, String> findActiveRemoteSyncIdsAndLastSyncStatusByPluginId(String pluginId) {
        return this.dslContext.select((SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REMOTE_SYNCHRONISATION.LAST_SYNC_STATUS).from((TableLike)Tables.REMOTE_SYNCHRONISATION).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)pluginId)).and(Tables.REMOTE_SYNCHRONISATION.SYNC_ENABLE.isTrue()).orderBy((OrderField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.desc()).fetchMap((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID, (Field)Tables.REMOTE_SYNCHRONISATION.LAST_SYNC_STATUS);
    }
}

