/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class TestCaseFolderCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public TestCaseFolderCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> testCaseFolders = this.collectTestCaseFolders(ids);
        this.appendMilestonesByProject(testCaseFolders);
        return testCaseFolders;
    }

    private Map<Long, DataRow> collectTestCaseFolders(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)DSL.count((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID).as("CHILD_COUNT")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(ids)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.TEST_CASE_FOLDER, (Long)tuple.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.TEST_CASE_FOLDER;
    }
}

