/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class ActionWordCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public ActionWordCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> actionWords = this.dsl.select((SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, (SelectField)Tables.ACTION_WORD_LIBRARY_NODE.NAME, (SelectField)Tables.ACTION_WORD.PROJECT_ID.as("projectId")).from((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).innerJoin((TableLike)Tables.ACTION_WORD).on(Tables.ACTION_WORD.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID)).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)ActionWordTreeDefinition.ACTION_WORD.name())).where(Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID.in(ids)).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.ACTION_WORD, (Long)tuple.get((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
        this.appendMilestonesByProject(actionWords);
        return actionWords;
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.ACTION_WORD;
    }
}

