/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.sprintgroup.SprintGroupDto;
import org.squashtest.tm.service.internal.repository.display.SprintGroupDisplayDao;

@Repository
public class SprintGroupDisplayDaoImpl
implements SprintGroupDisplayDao {
    private final DSLContext dsl;

    public SprintGroupDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public SprintGroupDto getSprintGroupDtoById(long sprintGroupId) {
        return (SprintGroupDto)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)sprintGroupId)).fetchOneInto(SprintGroupDto.class);
    }

    @Override
    public List<Long> findContainedSprintGroupIds(List<Long> campaignLibraryNodeIds) {
        return this.dsl.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(campaignLibraryNodeIds).or(Tables.SPRINT_GROUP.CLN_ID.in(campaignLibraryNodeIds))).fetchInto(Long.class);
    }

    @Override
    public Long findParentSprintGroupId(long nodeId) {
        return (Long)this.dsl.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).join((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId)).fetchOneInto(Long.class);
    }

    @Override
    public Map<Long, String> getSprintsInSprintGroup(long sprintGroupId) {
        return this.dsl.select((SelectField)Tables.SPRINT.CLN_ID, (SelectField)Tables.REMOTE_SYNCHRONISATION.KIND).from((TableLike)Tables.SPRINT).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.SPRINT.REMOTE_SYNCHRONISATION_ID)).join((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)sprintGroupId)).fetchMap((Field)Tables.SPRINT.CLN_ID, (Field)Tables.REMOTE_SYNCHRONISATION.KIND);
    }

    @Override
    public Boolean checkIfHasSynchronizedSprints(long sprintGroupId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.SPRINT.REMOTE_SYNCHRONISATION_ID)).join((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)sprintGroupId)));
    }
}

