/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.AutomationRequestDto;
import org.squashtest.tm.service.internal.repository.display.AutomationRequestDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RemoteAutomationRequestExtenderDisplayDao;

@Repository
public class AutomationRequestDisplayDaoImpl
implements AutomationRequestDisplayDao {
    private DSLContext dsl;
    private RemoteAutomationRequestExtenderDisplayDao extenderDao;

    public AutomationRequestDisplayDaoImpl(DSLContext dsl, RemoteAutomationRequestExtenderDisplayDao extenderDao) {
        this.extenderDao = extenderDao;
        this.dsl = dsl;
    }

    @Override
    public AutomationRequestDto findByTestCaseId(Long testCaseId) {
        Record record = this.dsl.select((SelectField)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.as("ID"), (SelectField)Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY.as("PRIORITY"), (SelectField)Tables.AUTOMATION_REQUEST.REQUEST_STATUS, (SelectField)Tables.AUTOMATION_REQUEST.TRANSMITTED_ON).from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).where(Tables.TEST_CASE.TCLN_ID.eq((Object)testCaseId)).fetchOne();
        AutomationRequestDto automationRequestDto = null;
        if (record != null) {
            automationRequestDto = (AutomationRequestDto)record.into(AutomationRequestDto.class);
            this.extenderDao.addRemoteExtender(automationRequestDto);
        }
        return automationRequestDto;
    }

    @Override
    public int countByAssignedTo(List<Long> readableProjectIds, Long userId) {
        Integer count = (Integer)this.baseRequest(readableProjectIds).and(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Object)userId)).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public int countTransmitted(List<Long> readableProjectIds) {
        Integer count = (Integer)this.baseRequest(readableProjectIds).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in(Arrays.asList(AutomationRequestStatus.AUTOMATION_IN_PROGRESS.name(), AutomationRequestStatus.TRANSMITTED.name()))).and(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.isNull()).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public int countAll(List<Long> readableProjectIds) {
        Integer count = (Integer)this.baseRequest(readableProjectIds).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public List<String> getTcLastModifiedByForCurrentUser(List<Long> projectIds, List<String> requestStatus, Long userId) {
        True condition = DSL.trueCondition();
        if (userId != null) {
            condition = Tables.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Object)userId);
        }
        return this.getTCLastModifiedByBaseRequest(projectIds, requestStatus).and((Condition)condition).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY);
    }

    @Override
    public List<String> getTcLastModifiedByToAutomationRequestNotAssigned(List<Long> projectIds, List<String> requestStatus) {
        return this.getTCLastModifiedByBaseRequest(projectIds, requestStatus).and(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.isNull()).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY);
    }

    @Override
    public List<String> getTcLastModifiedByForAutomationRequests(List<Long> projectIds, List<String> requestStatus) {
        return this.getTCLastModifiedByBaseRequest(projectIds, requestStatus).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY);
    }

    @Override
    public List<String> getAssignedUserForAutomationRequests(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.CORE_USER).on(Tables.AUTOMATION_REQUEST.ASSIGNED_TO.eq((Field)Tables.CORE_USER.PARTY_ID)).where(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.CORE_USER.LOGIN).fetch((Field)Tables.CORE_USER.LOGIN);
    }

    private SelectConditionStep<?> getTCLastModifiedByBaseRequest(List<Long> projectIds, List<String> requestStatus) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).where(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in(requestStatus)).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds));
    }

    private SelectConditionStep<?> baseRequest(List<Long> projectIds) {
        return this.dsl.selectCount().from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NATIVE.name())).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()));
    }
}

