/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ParentPivotEntity;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoader;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;

@Component
public class ContainerLoaderFactory {
    private final CampaignDao campaignDao;
    private final CampaignLibraryDao campaignLibraryDao;
    private final CampaignFolderDao campaignFolderDao;
    private final IterationDao iterationDao;
    private final RequirementLibraryDao requirementLibraryDao;
    private final RequirementFolderDao requirementFolderDao;
    private final SprintGroupDao sprintGroupDao;
    private final TestCaseLibraryDao testCaseLibraryDao;
    private final TestCaseFolderDao testCaseFolderDao;

    public ContainerLoaderFactory(CampaignDao campaignDao, CampaignLibraryDao campaignLibraryDao, CampaignFolderDao campaignFolderDao, IterationDao iterationDao, RequirementLibraryDao requirementLibraryDao, RequirementFolderDao requirementFolderDao, SprintGroupDao sprintGroupDao, TestCaseLibraryDao testCaseLibraryDao, TestCaseFolderDao testCaseFolderDao) {
        this.campaignDao = campaignDao;
        this.campaignLibraryDao = campaignLibraryDao;
        this.campaignFolderDao = campaignFolderDao;
        this.iterationDao = iterationDao;
        this.requirementLibraryDao = requirementLibraryDao;
        this.requirementFolderDao = requirementFolderDao;
        this.sprintGroupDao = sprintGroupDao;
        this.testCaseLibraryDao = testCaseLibraryDao;
        this.testCaseFolderDao = testCaseFolderDao;
    }

    public <E extends ParentPivotEntity> ContainerLoader loadContainers(EntityType mergedParentType, List<E> parentPivotEntities, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata) {
        ContainerLoader containerLoader = new ContainerLoader(this.getPivotIdConversion(mergedParentType, pivotImportMetadata));
        if (EntityType.CAMPAIGN_FOLDER.equals((Object)mergedParentType)) {
            this.handleMergedParentType(parentPivotEntities, containerLoader);
            return containerLoader;
        }
        if (ContainerLoader.isLibraryParentType(mergedParentType)) {
            this.appendLibraryContainers(containerLoader, mergedParentType, projectIdsReferences);
            return containerLoader;
        }
        Set<Long> ids = containerLoader.getIdFromPivotParentId(parentPivotEntities);
        this.appendContainers(containerLoader, mergedParentType, ids);
        return containerLoader;
    }

    private <E extends ParentPivotEntity> void handleMergedParentType(List<E> parentPivotEntities, ContainerLoader containerLoader) {
        parentPivotEntities.stream().collect(Collectors.groupingBy(ParentPivotEntity::getParentType, Collectors.toList())).forEach((parentType, pivots) -> {
            Set<Long> ids = containerLoader.getIdFromPivotParentId(pivots);
            this.appendContainers(containerLoader, (EntityType)parentType, ids);
        });
    }

    private void appendLibraryContainers(ContainerLoader containerLoader, EntityType entityType, ProjectIdsReferences projectIdsReferences) {
        Object container = switch (entityType) {
            case EntityType.REQUIREMENT_LIBRARY -> this.requirementLibraryDao.loadForNodeAddition(projectIdsReferences.getRequirementLibraryId());
            case EntityType.TEST_CASE_LIBRARY -> this.testCaseLibraryDao.loadForNodeAddition(projectIdsReferences.getTestCaseLibraryId());
            case EntityType.CAMPAIGN_LIBRARY -> this.campaignLibraryDao.loadForNodeAddition(projectIdsReferences.getCampaignLibraryId());
            default -> throw new IllegalArgumentException("Entity type is not a library: " + String.valueOf(entityType));
        };
        containerLoader.addContainer((NodeContainer<? extends TreeNode>)container);
    }

    private void appendContainers(ContainerLoader containerLoader, EntityType entityType, Set<Long> ids) {
        List<Object> containers = switch (entityType) {
            case EntityType.REQUIREMENT_FOLDER -> this.requirementFolderDao.loadForNodeAddition(ids);
            case EntityType.TEST_CASE_FOLDER -> this.testCaseFolderDao.loadForNodeAddition(ids);
            case EntityType.CAMPAIGN_FOLDER -> this.campaignFolderDao.loadForNodeAddition(ids);
            case EntityType.SPRINT_GROUP -> this.sprintGroupDao.loadContainersForPaste(ids);
            case EntityType.CAMPAIGN -> this.campaignDao.loadContainersForPaste(ids);
            case EntityType.ITERATION -> this.iterationDao.loadContainersForPaste(ids);
            default -> throw new IllegalArgumentException("Parent entity type not handled: " + String.valueOf(entityType));
        };
        containers.forEach(containerLoader::addContainer);
    }

    private Map<String, Long> getPivotIdConversion(EntityType entityType, PivotImportMetadata pivotImportMetadata) {
        return switch (entityType) {
            case EntityType.CAMPAIGN_LIBRARY, EntityType.REQUIREMENT_LIBRARY, EntityType.TEST_CASE_LIBRARY -> Map.of();
            case EntityType.REQUIREMENT_FOLDER -> pivotImportMetadata.getRequirementFolderIdByPivotId();
            case EntityType.TEST_CASE_FOLDER -> pivotImportMetadata.getTestCaseFolderIdByPivotId();
            case EntityType.CAMPAIGN_FOLDER, EntityType.SPRINT_GROUP -> pivotImportMetadata.getCampaignFolderIdByPivotId();
            case EntityType.CAMPAIGN -> pivotImportMetadata.getCampaignIdByPivotId();
            case EntityType.ITERATION -> pivotImportMetadata.getIterationIdByPivotId();
            default -> throw new IllegalArgumentException("Parent entity type not handled: " + String.valueOf(entityType));
        };
    }
}

