/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.util.Set;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.structures.StringPathMap;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.SheetCorruptedException;
import org.squashtest.tm.service.internal.archive.ArchiveReader;
import org.squashtest.tm.service.internal.archive.Entry;
import org.squashtest.tm.service.internal.importer.ExcelTestCaseParser;
import org.squashtest.tm.service.internal.importer.ImportSummaryImpl;

class HierarchyCreator {
    private ArchiveReader reader;
    private ExcelTestCaseParser parser;
    private GenericProject project;
    private StringPathMap<TestCaseLibraryNode> pathMap = new StringPathMap();
    private ImportSummaryImpl summary = new ImportSummaryImpl();
    private TestCaseFolder root = new TestCaseFolder();

    public HierarchyCreator() {
        this.root.setName("/");
        this.pathMap.put("/", (Object)this.root);
    }

    public void setArchiveReader(ArchiveReader reader) {
        this.reader = reader;
    }

    public void setParser(ExcelTestCaseParser parser) {
        this.parser = parser;
    }

    public void setProject(GenericProject genericProject) {
        this.project = genericProject;
    }

    public ImportSummaryImpl getSummary() {
        return this.summary;
    }

    public TestCaseFolder getNodes() {
        return this.root;
    }

    public void create() {
        while (this.reader.hasNext()) {
            Entry entry = (Entry)this.reader.next();
            if (entry.isDirectory()) {
                this.findOrCreateFolder(entry);
                continue;
            }
            this.createTestCase(entry);
        }
    }

    private TestCaseFolder findOrCreateFolder(Entry entry) {
        TestCaseFolder isFound = (TestCaseFolder)this.pathMap.getMappedElement(entry.getName());
        if (isFound != null) {
            return isFound;
        }
        TestCaseFolder parent = this.findOrCreateFolder(entry.getParent());
        TestCaseFolder newFolder = new TestCaseFolder();
        newFolder.setName(entry.getShortName());
        parent.addContent((TestCaseLibraryNode)newFolder);
        this.pathMap.put(entry.getName(), (Object)newFolder);
        return newFolder;
    }

    private void createTestCase(Entry entry) {
        try {
            this.summary.incrTotal();
            TestCase testCase = this.parser.parseFile(entry.getStream(), this.summary);
            this.fixNatureTypes(testCase);
            Set parameterNames = testCase.findUsedParamsNamesInSteps();
            for (String parameterName : parameterNames) {
                new Parameter(parameterName, testCase);
            }
            if (this.hasValidExtension(entry)) {
                testCase.setName(this.stripExtension(entry.getShortName()));
                TestCaseFolder parent = this.findOrCreateFolder(entry.getParent());
                parent.addContent((TestCaseLibraryNode)testCase);
                this.pathMap.put(entry.getName(), (Object)testCase);
            } else {
                this.summary.incrRejected();
            }
        }
        catch (SheetCorruptedException sheetCorruptedException) {
            this.summary.incrFailures();
        }
    }

    private boolean hasValidExtension(Entry entry) {
        return entry.getShortName().endsWith(".xls") || entry.getShortName().endsWith(".xlsx");
    }

    private String stripExtension(String withExtension) {
        return this.parser.stripFileExtension(withExtension);
    }

    private void fixNatureTypes(TestCase testCase) {
        InfoListItem importType;
        InfoListItem importNature = testCase.getNature();
        if (importNature == null || !this.project.getTestCaseNatures().contains(importNature)) {
            InfoListItem newNature = this.project.getTestCaseNatures().getDefaultItem();
            testCase.setNature(newNature);
            this.summary.incrModified();
        }
        if ((importType = testCase.getType()) == null || !this.project.getTestCaseTypes().contains(importType)) {
            InfoListItem newType = this.project.getTestCaseTypes().getDefaultItem();
            testCase.setType(newType);
            this.summary.incrModified();
        }
    }
}

